package org.mule.runtime.cfg.internal.node.errorhandling;

import org.mule.runtime.api.message.ErrorType;

import java.util.Optional;

/**
 * A node that is capable of interrupting the execution of the chain it belongs.
 */
public interface InterruptionCapableNode {

  /**
   * @return the error type this node raises when interrupting the execution. This is only non-empty if the interruption is
   *         unconditional.
   */
  Optional<ErrorType> alwaysInterruptsWithError();
}
