/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.cfg.api.BaseChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;

public class CountingVisitor
extends BaseChainExecutionPathTreeVisitor {
    public int sourceCount = 0;
    public int operationCount = 0;
    public int scopeCount = 0;
    public int routerCount = 0;
    public int errorHandlerCount = 0;
    public Map<String, Integer> potentialErrorInvocations = new HashMap<String, Integer>();
    public List<String> interruptedChains = new ArrayList<String>();

    public void visitSource(ChainExecutionPathTree source) {
        ++this.sourceCount;
    }

    public void visitSimpleOperation(ChainExecutionPathTree operation) {
        ++this.operationCount;
    }

    public boolean visitScope(ChainExecutionPathTree scope) {
        ++this.scopeCount;
        return true;
    }

    public boolean visitRouter(ChainExecutionPathTree router) {
        ++this.routerCount;
        return true;
    }

    public boolean errorHandlerStarted(ChainExecutionPathTree handler) {
        ++this.errorHandlerCount;
        return true;
    }

    public void errorHandlerCouldBeInvoked(ChainExecutionPathTree errorHandler, ErrorType errorType) {
        String location = errorHandler.getComponentAst().getLocation().getLocation();
        int invocations = this.potentialErrorInvocations.getOrDefault(location, 0);
        this.potentialErrorInvocations.put(location, invocations + 1);
    }

    public void chainInterruptedWithError(ChainExecutionPathTree chain) {
        this.interruptedChains.add(chain.getComponentAst().getLocation().getLocation());
    }
}

