/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.app.declaration.api;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclarationVisitor;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.internal.utils.Preconditions;

public final class ConfigurationElementDeclaration
extends ParameterizedElementDeclaration
implements GlobalElementDeclaration {
    private ConnectionElementDeclaration connection;
    private String elementName;

    public ConfigurationElementDeclaration() {
    }

    public ConfigurationElementDeclaration(String extension, String name) {
        this.setDeclaringExtension(extension);
        this.setName(name);
    }

    @Override
    public String getRefName() {
        return this.elementName;
    }

    @Override
    public void setRefName(String referableName) {
        Preconditions.checkArgument(referableName != null && !referableName.trim().isEmpty(), "Configuration referableName cannot be blank");
        this.elementName = referableName;
    }

    public Optional<ConnectionElementDeclaration> getConnection() {
        return Optional.ofNullable(this.connection);
    }

    public void setConnection(ConnectionElementDeclaration connection) {
        this.connection = connection;
    }

    @Override
    public <T extends ElementDeclaration> Optional<T> findElement(List<String> parts) {
        if (parts.isEmpty()) {
            return Optional.of(this);
        }
        if (parts.get(0).equals("connection")) {
            return Optional.ofNullable(this.connection);
        }
        return super.findElement(parts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationElementDeclaration) || !super.equals(o)) {
            return false;
        }
        ConfigurationElementDeclaration that = (ConfigurationElementDeclaration)o;
        return (this.connection != null ? this.connection.equals(that.connection) : that.connection == null) && this.elementName.equals(that.elementName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
        result = 31 * result + this.elementName.hashCode();
        return result;
    }

    @Override
    public void accept(GlobalElementDeclarationVisitor visitor) {
        visitor.visit(this);
    }
}

