/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.persistence;

import static java.nio.charset.Charset.defaultCharset;
import static org.apache.commons.io.IOUtils.resourceToString;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.connectivity.api.test.platform.ConnectivitySchemaTestUtils.getNetsuiteTokenAuthenticationSchema;
import static org.skyscreamer.jsonassert.JSONAssert.assertEquals;

import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.api.platform.schema.persistence.ConnectivitySchemaJsonSerializer;

import java.io.IOException;

import org.junit.Test;

public class DefaultConnectivitySchemaJsonSerializerTestCase {

  private ConnectivitySchemaJsonSerializer serializer = ConnectivitySchemaJsonSerializer.builder().build();

  @Test
  public void serializeNetsuiteSchema() throws Exception {
    ConnectivitySchema schema = getNetsuiteTokenAuthenticationSchema();
    String actual = serializer.serialize(schema);
    String expected = loadExpectedNetsuiteSchema();

    try {
      assertEquals(expected, actual, true);
    } catch (AssertionError e) {
      System.out.println(actual);
      throw e;
    }
  }

  @Test
  public void deserializeNetsuiteSchema() throws Exception {
    ConnectivitySchema schema = serializer.deserialize(loadExpectedNetsuiteSchema());
    assertThat(schema, equalTo(getNetsuiteTokenAuthenticationSchema()));
  }

  private String loadExpectedNetsuiteSchema() throws IOException {
    return resourceToString("/schema/connectivity-test-schema-netsuite.json", defaultCharset());
  }
}
