/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.api.platform.schema.persistence;


import org.mule.api.annotation.NoImplement;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.internal.persistence.DefaultConnectivitySchemaJsonSerializerBuilder;

/**
 * Serializer for marshalling/unmarshalling {@link ConnectivitySchema} instances into JSON
 *
 * @since 1.0
 */
@NoImplement
public interface ConnectivitySchemaJsonSerializer {

  /**
   * Builder for creating instances of {@link ConnectivitySchemaJsonSerializer}
   *
   * @since 1.0
   */
  @NoImplement
  interface Builder {

    /**
     * Set to {@code true} to automatically indent the JSON documents produced by the
     * {@link ConnectivitySchemaJsonSerializer#serialize(ConnectivitySchema)} method
     *
     * @param autoIndent whether to auto indent or not
     * @return {@code this} builder
     */
    Builder autoIndent(boolean autoIndent);

    /**
     * @return a new serializer instance
     */
    ConnectivitySchemaJsonSerializer build();
  }

  /**
   * @return a new builder instance.
   */
  static Builder builder() {
    return new DefaultConnectivitySchemaJsonSerializerBuilder();
  }

  /**
   * @param schema a {@link ConnectivitySchema}
   * @return a Json representation of the given {@code schema}
   */
  String serialize(ConnectivitySchema schema);

  /**
   * Unmarshalls the given {@code json} into a {@link ConnectivitySchema}
   *
   * @param json a json document
   * @return an equivalent {@link ConnectivitySchema}
   */
  ConnectivitySchema deserialize(String json);
}
