/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.connectivity.internal.persistence;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.api.platform.schema.persistence.ConnectivitySchemaJsonSerializer;
import org.mule.runtime.connectivity.api.test.platform.ConnectivitySchemaTestUtils;
import org.skyscreamer.jsonassert.JSONAssert;

public class DefaultConnectivitySchemaJsonSerializerTestCase {
    private ConnectivitySchemaJsonSerializer serializer = ConnectivitySchemaJsonSerializer.builder().build();

    @Test
    public void serializeNetsuiteSchema() throws Exception {
        ConnectivitySchema schema = ConnectivitySchemaTestUtils.getNetsuiteTokenAuthenticationSchema();
        String actual = this.serializer.serialize(schema);
        String expected = this.loadExpectedNetsuiteSchema();
        try {
            JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
        }
        catch (AssertionError e) {
            System.out.println(actual);
            throw e;
        }
    }

    @Test
    public void deserializeNetsuiteSchema() throws Exception {
        ConnectivitySchema schema = this.serializer.deserialize(this.loadExpectedNetsuiteSchema());
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)ConnectivitySchemaTestUtils.getNetsuiteTokenAuthenticationSchema()));
    }

    private String loadExpectedNetsuiteSchema() throws IOException {
        return IOUtils.resourceToString((String)"/schema/connectivity-test-schema-netsuite.json", (Charset)Charset.defaultCharset());
    }
}

