/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.persistence;

import org.mule.runtime.connectivity.api.platform.schema.persistence.ConnectivitySchemaJsonSerializer;
import org.mule.runtime.connectivity.api.platform.schema.persistence.ConnectivitySchemaJsonSerializer.Builder;

/**
 * Default implementatio of {@link Builder}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchemaJsonSerializerBuilder implements Builder {

  private boolean prettyPrint = true;

  /**
   * {@inheritDoc}
   */
  @Override
  public Builder autoIndent(boolean autoIndent) {
    this.prettyPrint = autoIndent;
    return this;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectivitySchemaJsonSerializer build() {
    return new DefaultConnectivitySchemaJsonSerializer(prettyPrint);
  }
}
