/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.api.platform.schema;

import org.mule.api.annotation.NoImplement;

import java.util.List;
import java.util.Map;

/**
 * Models an AML dialect used by the CFM service to represent a connection schema
 *
 * @since 1.0
 */
@NoImplement
public interface ConnectivitySchema {

  /**
   * @return the schema's groupId
   */
  String getGroupId();

  /**
   * @return the schema's artifact id
   */
  String getArtifactId();

  /**
   * @return the schema's version
   */
  String getVersion();

  /**
   * @return The schema's labels
   */
  Map<String, String> getLabels();

  /**
   * @return The schema's assets
   */
  List<ExchangeAssetDescriptor> getAssets();

  /**
   * @return The schema's definition
   */
  ConnectivitySchemaDefinition getDefinition();
}
