/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.api.platform.schema;

import org.mule.api.annotation.NoImplement;

/**
 * Models a parameter within a {@link ConnectivitySchema}
 *
 * @since 1.0
 */
@NoImplement
public interface ConnectivitySchemaParameter {

  /**
   * @return the parameter's property term
   */
  String getPropertyTerm();

  /**
   * @return the parameter's range
   */
  String getRange();

  /**
   * @return whether the parameter is mandatory or not
   */
  boolean isMandatory();
}
