/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaNode;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaParameter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Default implementation of {@link ConnectivitySchemaNode}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchemaNode implements ConnectivitySchemaNode {

  private String classTerm;
  private Map<String, ConnectivitySchemaParameter> mapping = new LinkedHashMap<>();

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClassTerm() {
    return classTerm;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, ConnectivitySchemaParameter> getMappings() {
    return mapping;
  }

  public void setClassTerm(String classTerm) {
    this.classTerm = classTerm;
  }

  @Override
  public boolean equals(Object o) {
    if (o instanceof ConnectivitySchemaNode) {
      ConnectivitySchemaNode that = (ConnectivitySchemaNode) o;
      return Objects.equals(classTerm, that.getClassTerm()) && Objects.equals(mapping, that.getMappings());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(classTerm, mapping);
  }
}
