/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.connectivity.internal.platform.schema.builder;

import java.util.function.Consumer;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.api.platform.schema.ExchangeAssetDescriptor;
import org.mule.runtime.connectivity.api.platform.schema.builder.ConnectivitySchemaBuilder;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchema;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaNode;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaParameter;
import org.mule.runtime.connectivity.internal.platform.schema.DefaultConnectivitySchemaRoot;

public class DefaultConnectivitySchemaBuilder
implements ConnectivitySchemaBuilder {
    private final DefaultConnectivitySchema product = new DefaultConnectivitySchema();
    private final DefaultConnectivitySchemaNode connectionNode = new DefaultConnectivitySchemaNode();

    public DefaultConnectivitySchemaBuilder() {
        this.product.getDefinition().getNodeMappings().put("Connection", this.connectionNode);
        DefaultConnectivitySchemaRoot root = (DefaultConnectivitySchemaRoot)this.product.getDefinition().getDocument().getRoot();
        root.setEncodes("Connection");
        this.uses("connectivity", "anypoint://vocabulary/connectivity.yaml").uses("core", "anypoint://vocabulary/core.yaml").uses("apiContract", "anypoint://vocabulary/api-contract.yaml");
    }

    @Override
    public ConnectivitySchemaBuilder gav(String groupId, String artifactId, String version) {
        this.product.setGroupId(groupId);
        this.product.setArtifactId(artifactId);
        this.product.setVersion(version);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder authenticationType(String authenticationType) {
        this.product.getLabels().put("type", authenticationType);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder system(String system) {
        this.product.getLabels().put("system", system);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder connectionProviderName(String connectionProviderName) {
        this.product.getLabels().put("connectionProvider", connectionProviderName);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder withLabel(String key, String value) {
        this.product.getLabels().put(key, value);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder addAsset(ExchangeAssetDescriptor assetDescriptor) {
        this.product.getAssets().add(assetDescriptor);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder uses(String ns, String url) {
        this.product.getDefinition().getUses().put(ns, url);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder usesExternal(String ns, String url) {
        this.product.getDefinition().getExternal().put(ns, url);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder connectionClassTerm(String classTerm) {
        this.connectionNode.setClassTerm(classTerm);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder withParameter(String name, Consumer<ConnectivitySchemaBuilder.ConnectionParameterConfigurer> configurerConsumer) {
        DefaultConnectionParameterConfigurer configurer = new DefaultConnectionParameterConfigurer();
        configurerConsumer.accept(configurer);
        this.connectionNode.getMappings().put(name, configurer.product);
        return this;
    }

    @Override
    public ConnectivitySchemaBuilder withCustomRange(String name, Consumer<ConnectivitySchemaBuilder.CustomRangeConfigurer> configurerConsumer) {
        DefaultCustomRangeConfigurer configurer = new DefaultCustomRangeConfigurer();
        configurerConsumer.accept(configurer);
        this.product.getDefinition().getNodeMappings().put(name, configurer.product);
        return this;
    }

    @Override
    public ConnectivitySchema build() {
        return this.product;
    }

    private static class DefaultConnectionParameterConfigurer
    implements ConnectivitySchemaBuilder.ConnectionParameterConfigurer {
        private DefaultConnectivitySchemaParameter product = new DefaultConnectivitySchemaParameter();

        private DefaultConnectionParameterConfigurer() {
        }

        @Override
        public ConnectivitySchemaBuilder.ConnectionParameterConfigurer setPropertyTerm(String propertyTerm) {
            this.product.setPropertyTerm(propertyTerm);
            return this;
        }

        @Override
        public ConnectivitySchemaBuilder.ConnectionParameterConfigurer setRange(String range) {
            this.product.setRange(range);
            return this;
        }

        @Override
        public ConnectivitySchemaBuilder.ConnectionParameterConfigurer setMandatory(boolean mandatory) {
            this.product.setMandatory(mandatory);
            return this;
        }
    }

    private static class DefaultCustomRangeConfigurer
    implements ConnectivitySchemaBuilder.CustomRangeConfigurer {
        private DefaultConnectivitySchemaNode product = new DefaultConnectivitySchemaNode();

        private DefaultCustomRangeConfigurer() {
        }

        @Override
        public ConnectivitySchemaBuilder.CustomRangeConfigurer setClassTerm(String classTerm) {
            this.product.setClassTerm(classTerm);
            return this;
        }

        @Override
        public ConnectivitySchemaBuilder.CustomRangeConfigurer addParameter(String name, Consumer<ConnectivitySchemaBuilder.ConnectionParameterConfigurer> configurerConsumer) {
            DefaultConnectionParameterConfigurer configurer = new DefaultConnectionParameterConfigurer();
            configurerConsumer.accept(configurer);
            this.product.getMappings().put(name, configurer.product);
            return this;
        }
    }
}

