/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.api.platform.schema;

import org.mule.api.annotation.NoImplement;

import java.util.Map;

/**
 * The definition section of a {@link ConnectivitySchema}
 *
 * @since 1.0
 */
@NoImplement
public interface ConnectivitySchemaDefinition {

  /**
   * @return the schema body
   */
  ConnectivitySchemaBody getDocument();

  /**
   * Returns the vocabularies this schema depends on as a {@link Map} which key is an alias and the values a vocabulary URL
   *
   * @return the vocabulary dependencies
   */
  Map<String, String> getUses();

  /**
   * Returns the schema extenral dependencies on as a {@link Map} which key is an alias and the values are a URL
   *
   * @return the schema dependencies
   */
  Map<String, String> getExternal();

  /**
   * @return the schema mapping nodes.
   */
  Map<String, ConnectivitySchemaNode> getNodeMappings();
}
