/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.api.platform.schema;

import org.mule.api.annotation.NoImplement;

import java.util.Map;

/**
 * Models a node within a {@link ConnectivitySchema}
 *
 * @since 1.0
 */
@NoImplement
public interface ConnectivitySchemaNode {

  /**
   * @return the node's classterm
   */
  String getClassTerm();

  /**
   * Returns the node's parameters as a {@link Map} which keys are the parameter names and the values are the parameters
   * themselves, modeled as {@link ConnectivitySchemaParameter} instances
   *
   * @return the node's parameters
   */
  Map<String, ConnectivitySchemaParameter> getMappings();

}
