/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaBody;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaDefinition;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaNode;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Default implementation of {@link ConnectivitySchemaDefinition}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchemaDefinition implements ConnectivitySchemaDefinition {

  private DefaultConnectivitySchemaBody documents = new DefaultConnectivitySchemaBody();

  private Map<String, String> uses = new LinkedHashMap<>();
  private Map<String, String> external = new LinkedHashMap<>();
  private Map<String, ConnectivitySchemaNode> nodeMappings = new LinkedHashMap<>();

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectivitySchemaBody getDocument() {
    return documents;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, String> getUses() {
    return uses;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, String> getExternal() {
    return external;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, ConnectivitySchemaNode> getNodeMappings() {
    return nodeMappings;
  }

  @Override
  public boolean equals(Object o) {
    if (o instanceof ConnectivitySchemaDefinition) {
      ConnectivitySchemaDefinition that = (ConnectivitySchemaDefinition) o;
      return Objects.equals(documents, that.getDocument())
          && Objects.equals(uses, that.getUses())
          && Objects.equals(external, that.getExternal())
          && Objects.equals(nodeMappings, that.getNodeMappings());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(documents, uses, external, nodeMappings);
  }
}
