/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaRoot;

import java.util.Objects;

/**
 * Default implementation of {@link ConnectivitySchemaRoot}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchemaRoot implements ConnectivitySchemaRoot {

  private String encodes;

  /**
   * {@inheritDoc}
   */
  @Override
  public String getEncodes() {
    return encodes;
  }

  /**
   * Sets the entity type encoded in the document
   *
   * @param encodes the entity type
   */
  public void setEncodes(String encodes) {
    this.encodes = encodes;
  }

  @Override
  public boolean equals(Object o) {
    if (o instanceof ConnectivitySchemaRoot) {
      ConnectivitySchemaRoot that = (ConnectivitySchemaRoot) o;
      return Objects.equals(encodes, that.getEncodes());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(encodes);
  }
}
