/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.AbstractFruit;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.tck.testmodels.fruit.Orange;

@SmallTest
public class ClassUtilsTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected final Set<String> ignoreMethods = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler"));

    @Test
    public void testIsConcrete() throws Exception {
        MatcherAssert.assertThat((Object)ClassUtils.isConcrete(Orange.class), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isConcrete(Fruit.class), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.isConcrete(AbstractFruit.class), (Matcher)CoreMatchers.is((Object)false));
        try {
            ClassUtils.isConcrete(null);
            Assert.fail((String)"Class cannot be null, exception should be thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadClass() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.String", ((Object)((Object)this)).getClass());
        MatcherAssert.assertThat((Object)clazz, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)clazz.getName(), (Matcher)CoreMatchers.is((Object)"java.lang.String"));
        try {
            ClassUtils.loadClass((String)"java.lang.Bing", ((Object)((Object)this)).getClass());
            Assert.fail((String)"ClassNotFoundException should be thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadPrimitiveClass() throws Exception {
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"boolean", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Boolean.TYPE));
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"byte", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Byte.TYPE));
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"char", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Character.TYPE));
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"double", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Double.TYPE));
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"float", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Float.TYPE));
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"int", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Integer.TYPE));
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"long", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Long.TYPE));
        MatcherAssert.assertThat((Object)ClassUtils.loadClass((String)"short", ((Object)((Object)this)).getClass()), (Matcher)CoreMatchers.sameInstance(Short.TYPE));
    }

    @Test
    public void testLoadClassOfType() throws Exception {
        Class clazz = ClassUtils.loadClass((String)"java.lang.IllegalArgumentException", ((Object)((Object)this)).getClass(), Exception.class);
        MatcherAssert.assertThat((Object)clazz, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)clazz.getName(), (Matcher)CoreMatchers.is((Object)"java.lang.IllegalArgumentException"));
        try {
            ClassUtils.loadClass((String)"java.lang.UnsupportedOperationException", ((Object)((Object)this)).getClass(), String.class);
            Assert.fail((String)"IllegalArgumentException should be thrown since class is not of expected type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInstanciateClass() throws Exception {
        Object object = ClassUtils.instantiateClass((String)"org.mule.tck.testmodels.fruit.Orange", (Object[])new Object[0]);
        MatcherAssert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Orange.class)));
        object = ClassUtils.instantiateClass((String)"org.mule.tck.testmodels.fruit.FruitBowl", (Object[])new Object[]{new Apple(), new Banana()});
        MatcherAssert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)object, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FruitBowl.class)));
        FruitBowl bowl = (FruitBowl)object;
        MatcherAssert.assertThat((Object)bowl.hasApple(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)bowl.hasBanana(), (Matcher)CoreMatchers.is((Object)true));
        try {
            ClassUtils.instantiateClass((String)"java.lang.Bing", (Object[])new Object[0]);
            Assert.fail((String)"Class does not exist, ClassNotFoundException should have been thrown");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testGetParameterTypes() throws Exception {
        FruitBowl bowl = new FruitBowl();
        Class[] classes = ClassUtils.getParameterTypes((Object)bowl, (String)"apple");
        MatcherAssert.assertThat((Object)classes, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)classes.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        MatcherAssert.assertThat((Object)classes[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Apple.class)));
        classes = ClassUtils.getParameterTypes((Object)bowl, (String)"invalid");
        MatcherAssert.assertThat((Object)classes, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)classes.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }

    @Test
    public void testLoadingResources() throws Exception {
        URL resource = ClassUtils.getResource((String)"log4j2-test.xml", ((Object)((Object)this)).getClass());
        MatcherAssert.assertThat((Object)resource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        resource = ClassUtils.getResource((String)"does-not-exist.properties", ((Object)((Object)this)).getClass());
        MatcherAssert.assertThat((Object)resource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLoadingResourceEnumeration() throws Exception {
        Enumeration enumeration = ClassUtils.getResources((String)"log4j2-test.xml", ((Object)((Object)this)).getClass());
        MatcherAssert.assertThat((Object)enumeration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)enumeration.hasMoreElements(), (Matcher)CoreMatchers.is((Object)true));
        enumeration = ClassUtils.getResources((String)"does-not-exist.properties", ((Object)((Object)this)).getClass());
        MatcherAssert.assertThat((Object)enumeration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)enumeration.hasMoreElements(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testSimpleName() {
        this.simpleNameHelper("String", "foo".getClass());
        this.simpleNameHelper("int[]", new int[0].getClass());
        this.simpleNameHelper("Object[][]", new Object[0][0].getClass());
        this.simpleNameHelper("null", null);
    }

    @Test
    public void testEqual() {
        HashBlob a1 = new HashBlob(1);
        HashBlob a2 = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        MatcherAssert.assertThat((Object)ClassUtils.equal((Object)a1, (Object)a2), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.equal((Object)b, (Object)b), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.equal(null, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.equal((Object)a1, (Object)b), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.equal((Object)a2, (Object)b), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.equal(null, (Object)b), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.equal((Object)b, (Object)a1), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.equal((Object)b, (Object)a2), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.equal((Object)b, null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testHash() {
        HashBlob a = new HashBlob(1);
        HashBlob b = new HashBlob(2);
        MatcherAssert.assertThat((Object)ClassUtils.hash((Object[])new Object[]{a, b, a, b}), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ClassUtils.hash((Object[])new Object[]{a, b, a, b}))));
        MatcherAssert.assertThat((Object)ClassUtils.hash((Object[])new Object[]{a, b, a}), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)ClassUtils.hash((Object[])new Object[]{a, b, a, b})))));
        MatcherAssert.assertThat((Object)ClassUtils.hash((Object[])new Object[]{a, b, a, a}), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)ClassUtils.hash((Object[])new Object[]{a, b, a, b})))));
        MatcherAssert.assertThat((Object)ClassUtils.hash((Object[])new Object[]{b, a, b, a}), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)ClassUtils.hash((Object[])new Object[]{a, b, a, b})))));
    }

    @Test
    public void testClassTypesWithNullInArray() {
        Object[] array = new Object[]{"hello", null, "world"};
        Class[] classTypes = ClassUtils.getClassTypes((Object)array);
        MatcherAssert.assertThat((Object)classTypes.length, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        MatcherAssert.assertThat((Object)classTypes[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
        MatcherAssert.assertThat((Object)classTypes[1], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)classTypes[2], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
    }

    @Test
    public void getField() throws Exception {
        Field field = ClassUtils.getField(HashBlob.class, (String)"hash", (boolean)false);
        MatcherAssert.assertThat((Object)field, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=NoSuchFieldException.class)
    public void getNotExistentField() throws Exception {
        Field field = ClassUtils.getField(HashBlob.class, (String)"wrongField", (boolean)false);
    }

    @Test
    public void getFieldRecursive() throws Exception {
        Field field = ClassUtils.getField(ExtendedHashBlob.class, (String)"hash", (boolean)true);
        MatcherAssert.assertThat((Object)field, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=NoSuchFieldException.class)
    public void getNotExistentFieldRecursiveFieldInSuper() throws Exception {
        Field field = ClassUtils.getField(ExtendedHashBlob.class, (String)"hash", (boolean)false);
    }

    @Test(expected=NoSuchFieldException.class)
    public void getNotExistentFieldRecursive() throws Exception {
        Field field = ClassUtils.getField(ExtendedHashBlob.class, (String)"wrongField", (boolean)true);
    }

    @Test
    public void getFieldValue() throws Exception {
        int hash = ((Object)((Object)this)).hashCode();
        HashBlob blob = new HashBlob(hash);
        MatcherAssert.assertThat((Object)hash, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Integer)ClassUtils.getFieldValue((Object)blob, (String)"hash", (boolean)false)))));
    }

    @Test(expected=NoSuchFieldException.class)
    public void getNotExistentFieldValue() throws Exception {
        ClassUtils.getFieldValue((Object)new HashBlob(0), (String)"wrongField", (boolean)false);
    }

    @Test
    public void getFieldValueRecursive() throws Exception {
        int hash = ((Object)((Object)this)).hashCode();
        ExtendedHashBlob blob = new ExtendedHashBlob(hash);
        MatcherAssert.assertThat((Object)hash, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((Integer)ClassUtils.getFieldValue((Object)blob, (String)"hash", (boolean)true)))));
    }

    @Test(expected=NoSuchFieldException.class)
    public void getNotExistentFieldValueRecursive() throws Exception {
        ClassUtils.getFieldValue((Object)new ExtendedHashBlob(1), (String)"fake", (boolean)true);
    }

    @Test(expected=NoSuchFieldException.class)
    public void getInheritedFieldValueWithoutRecurse() throws Exception {
        ClassUtils.getFieldValue((Object)new ExtendedHashBlob(1), (String)"hash", (boolean)false);
    }

    @Test
    public void getStaticFieldValueRecursive() throws Exception {
        List<String> hashBlobProperties = Arrays.asList("one", "two");
        ExtendedHashBlob.setStaticHashProperties(hashBlobProperties);
        List value = (List)ClassUtils.getStaticFieldValue(ExtendedHashBlob.class, (String)"staticHashProperties", (boolean)true);
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo(hashBlobProperties));
    }

    @Test(expected=NoSuchFieldException.class)
    public void getStaticFieldValueNotExistentField() throws Exception {
        ClassUtils.getStaticFieldValue(ExtendedHashBlob.class, (String)"fake", (boolean)false);
    }

    @Test(expected=NoSuchFieldException.class)
    public void getStaticFieldValueNotExistentFieldRecursive() throws Exception {
        ClassUtils.getStaticFieldValue(ExtendedHashBlob.class, (String)"fake", (boolean)true);
    }

    @Test(expected=IllegalAccessException.class)
    public void getStaticFieldValueNotStaticField() throws Exception {
        ClassUtils.getStaticFieldValue(HashBlob.class, (String)"hash", (boolean)false);
    }

    @Test
    public void setFieldValue() throws Exception {
        HashBlob blob = new HashBlob(0);
        int hash = ((Object)((Object)this)).hashCode();
        ClassUtils.setFieldValue((Object)blob, (String)"hash", (Object)hash, (boolean)false);
        MatcherAssert.assertThat((Object)hash, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)blob.getHash())));
    }

    @Test
    public void setFinalFieldValue() throws Exception {
        int originalHash = ((Object)((Object)this)).hashCode();
        List<String> newFinalHashProperties = Arrays.asList("three", "four");
        HashBlob blob = new HashBlob(originalHash);
        MatcherAssert.assertThat(blob.getFinalHashProperties(), (Matcher)CoreMatchers.equalTo(Arrays.asList("one", "two")));
        ClassUtils.setFieldValue((Object)blob, (String)"finalHashProperties", newFinalHashProperties, (boolean)false);
        MatcherAssert.assertThat(newFinalHashProperties, (Matcher)CoreMatchers.equalTo(blob.getFinalHashProperties()));
    }

    @Test
    public void setFinalFieldValueRecursive() throws Exception {
        int originalHash = ((Object)((Object)this)).hashCode();
        List<String> newFinalHashProperties = Arrays.asList("three", "four");
        ExtendedHashBlob blob = new ExtendedHashBlob(originalHash);
        MatcherAssert.assertThat(blob.getFinalHashProperties(), (Matcher)CoreMatchers.equalTo(Arrays.asList("one", "two")));
        ClassUtils.setFieldValue((Object)blob, (String)"finalHashProperties", newFinalHashProperties, (boolean)true);
        MatcherAssert.assertThat(newFinalHashProperties, (Matcher)CoreMatchers.equalTo(blob.getFinalHashProperties()));
    }

    @Test
    public void setFinalStaticFieldValue() throws Exception {
        List<String> newFinalStaticHashProperties = Arrays.asList("three", "four");
        if (this.isStaticFinalModificationForbidden()) {
            this.expectedException.expect(IllegalAccessException.class);
            this.expectedException.expectMessage("Can not set static final");
        }
        ClassUtils.setStaticFieldValue(HashBlob.class, (String)"finalStaticHashProperties", newFinalStaticHashProperties, (boolean)true);
        MatcherAssert.assertThat(newFinalStaticHashProperties, (Matcher)CoreMatchers.equalTo(HashBlob.getFinalStaticHashProperties()));
    }

    @Test
    public void setFinalStaticFieldRecursive() throws Exception {
        List<String> newFinalStaticHashProperties = Arrays.asList("three", "four");
        if (this.isStaticFinalModificationForbidden()) {
            this.expectedException.expect(IllegalAccessException.class);
            this.expectedException.expectMessage("Can not set static final");
        }
        ClassUtils.setStaticFieldValue(ExtendedHashBlob.class, (String)"finalStaticHashProperties", newFinalStaticHashProperties, (boolean)true);
        MatcherAssert.assertThat(newFinalStaticHashProperties, (Matcher)CoreMatchers.equalTo(ExtendedHashBlob.getFinalStaticHashProperties()));
    }

    private boolean isStaticFinalModificationForbidden() {
        return SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17);
    }

    @Test(expected=NoSuchFieldException.class)
    public void setUnexistentFieldValue() throws Exception {
        ClassUtils.setFieldValue((Object)new HashBlob(0), (String)"fake", (Object)0, (boolean)false);
    }

    @Test
    public void setFieldValueRecursive() throws Exception {
        ExtendedHashBlob blob = new ExtendedHashBlob(0);
        int hash = ((Object)((Object)this)).hashCode();
        ClassUtils.setFieldValue((Object)blob, (String)"hash", (Object)hash, (boolean)true);
        MatcherAssert.assertThat((Object)hash, (Matcher)CoreMatchers.equalTo((Object)blob.getHash()));
    }

    @Test(expected=NoSuchFieldException.class)
    public void setUnexistentFieldValueRecursive() throws Exception {
        ClassUtils.setFieldValue((Object)new ExtendedHashBlob(1), (String)"fake", (Object)0, (boolean)true);
    }

    @Test(expected=NoSuchFieldException.class)
    public void setInheritedFieldValueWithoutRecurse() throws Exception {
        ClassUtils.setFieldValue((Object)new ExtendedHashBlob(1), (String)"hash", (Object)0, (boolean)false);
    }

    @Test
    public void isInstance() {
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(String.class, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(String.class, (Object)""), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Fruit.class, (Object)new Apple()), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Apple.class, (Object)new Kiwi()), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Integer.class, (Object)0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Integer.TYPE, (Object)0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Long.TYPE, (Object)new Long(0L)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Double.class, (Object)new Double(0.0)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Double.TYPE, (Object)new Double(0.0)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Boolean.TYPE, (Object)true), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Boolean.TYPE, (Object)Boolean.TRUE), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Boolean.class, (Object)true), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(String.class, (Object)true), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ClassUtils.isInstance(Long.TYPE, (Object)Boolean.FALSE), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void runWithClassLoader() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader mockClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)mockClassLoader, () -> this.assertContextClassLoader(mockClassLoader));
        this.assertContextClassLoader(originalClassLoader);
    }

    @Test
    public void returnWithClassLoader() {
        String value = "Hello World!";
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader mockClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        String response = (String)ClassUtils.withContextClassLoader((ClassLoader)mockClassLoader, () -> {
            this.assertContextClassLoader(mockClassLoader);
            return "Hello World!";
        });
        this.assertContextClassLoader(originalClassLoader);
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.is((Object)"Hello World!"));
    }

    private void assertContextClassLoader(ClassLoader mockClassLoader) {
        MatcherAssert.assertThat((Object)Thread.currentThread().getContextClassLoader(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)mockClassLoader)));
    }

    private void simpleNameHelper(String target, Class clazz) {
        MatcherAssert.assertThat((Object)ClassUtils.getSimpleName((Class)clazz), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)target)));
    }

    private static class HashBlob {
        private int hash;
        private static List<String> staticHashProperties = new ArrayList<String>();
        private final List<String> finalHashProperties = Arrays.asList("one", "two");
        private static final List<String> finalStaticHashProperties = Arrays.asList("one", "two");

        public HashBlob(int hash) {
            this.hash = hash;
        }

        private int getHash() {
            return this.hash;
        }

        public static void setStaticHashProperties(List<String> properties) {
            staticHashProperties = properties;
        }

        public static List<String> getFinalStaticHashProperties() {
            return finalStaticHashProperties;
        }

        public List<String> getFinalHashProperties() {
            return this.finalHashProperties;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (null == other || !this.getClass().equals(other.getClass())) {
                return false;
            }
            return this.hash == ((HashBlob)other).hash;
        }
    }

    private static class ExtendedHashBlob
    extends HashBlob {
        public ExtendedHashBlob(int hash) {
            super(hash);
        }
    }
}

