/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.core.api.util;

import static org.apache.commons.io.IOUtils.toByteArray;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;

import org.mule.runtime.core.api.util.compression.GZIPCompressorInputStream;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

import java.io.ByteArrayInputStream;
import java.util.zip.GZIPInputStream;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Test;

@SmallTest
public class Base64TestCase extends AbstractMuleTestCase {

  @Test
  void decodeWithoutUnzipping() throws Exception {
    final String payload = RandomStringUtils.randomAlphabetic(1024);
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(payload.getBytes());
    GZIPCompressorInputStream gzipCompressorInputStream = new GZIPCompressorInputStream(byteArrayInputStream);

    String encoded = Base64.encodeBytes(toByteArray(gzipCompressorInputStream), Base64.DONT_BREAK_LINES);
    GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(Base64.decodeWithoutUnzipping(encoded)));

    assertThat(IOUtils.toString(gzipInputStream), is(payload));
  }
}
