/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

/**
 * Deprecated utility classes, removed from mule-core.
 *
 * @moduleGraph
 *
 * <h1>Migration Guide for org.mule.runtime.core.api.util Package and Subpackages</h1>
 * <p>
 * This guide provides comprehensive migration instructions for all deprecated utility classes in the
 * {@code org.mule.runtime.core.api.util} package and its subpackages. All these utilities have been deprecated since
 * version 4.10 or 4.11 and are marked for removal in future versions.
 * </p>
 *
 * <h2>Package Overview</h2>
 * <p>
 * The deprecated utilities are located in the {@code org.mule.runtime.core.utils} module and include:
 * </p>
 * <ul>
 * <li>{@code org.mule.runtime.core.api.util} - Main utility classes</li>
 * <li>{@code org.mule.runtime.core.api.util.concurrent} - Threading utilities</li>
 * <li>{@code org.mule.runtime.core.api.util.compression} - Compression utilities</li>
 * <li>{@code org.mule.runtime.core.api.util.func} - Functional programming utilities</li>
 * <li>{@code org.mule.runtime.core.api.util.proxy} - Proxy utilities</li>
 * <li>{@code org.mule.runtime.core.api.util.xmlsecurity} - XML security utilities</li>
 * </ul>
 *
 * <h2>Main Package Utilities (org.mule.runtime.core.api.util)</h2>
 *
 * <h3>Base64</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link java.util.Base64} instead
 * </p>
 * <p>
 * <strong>Example:</strong> Replace Base64.encode(data) with Base64.getEncoder().encodeToString(data)
 * </p>
 *
 * <h3>CaseInsensitiveHashMap</h3>
 * <p>
 * <strong>Migration:</strong> Use Apache Commons Collections CaseInsensitiveMap or TreeMap with
 * String.CASE_INSENSITIVE_ORDER
 * </p>
 *
 * <h3>ClassUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.apache.commons.lang3.ClassUtils} or standard Java Reflection
 * </p>
 * <p>
 * <strong>Example:</strong> Replace ClassUtils.loadClass() with ClassLoader.loadClass()
 * </p>
 *
 * <h3>ExceptionUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.apache.commons.lang3.exception.ExceptionUtils}
 * </p>
 *
 * <h3>FileUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.apache.commons.io.FileUtils} or {@link java.nio.file.Files}
 * </p>
 * <p>
 * <strong>Example:</strong> Replace FileUtils.stringToFile() with Files.writeString()
 * </p>
 *
 * <h3>IOUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.apache.commons.io.IOUtils}
 * </p>
 *
 * <h3>NetworkUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use standard Java networking APIs
 * </p>
 * <p>
 * <strong>Example:</strong> Replace NetworkUtils.findFreePort() with ServerSocket(0).getLocalPort()
 * </p>
 *
 * <h3>ObjectUtils</h3>
 * <p>
 * <strong>Migration:</strong> Copy the needed methods or use standard Java utilities
 * </p>
 *
 * <h3>PropertiesUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use standard {@link java.util.Properties} or configuration frameworks
 * </p>
 *
 * <h3>StringMessageUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link java.text.MessageFormat} or {@link String#format}
 * </p>
 *
 * <h3>StringUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.apache.commons.lang3.StringUtils} or {@link java.util.HexFormat}
 * </p>
 *
 * <h3>StreamingUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use Mule's streaming APIs directly
 * </p>
 *
 * <h3>StreamCloserService</h3>
 * <p>
 * <strong>Migration:</strong> Use try-with-resources or manual resource management
 * </p>
 *
 * <h3>SystemUtils</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.apache.commons.lang3.SystemUtils}
 * </p>
 *
 * <h3>UUID</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link java.util.UUID}
 * </p>
 * <p>
 * <strong>Example:</strong> Replace UUID.getUUID() with UUID.randomUUID().toString()
 * </p>
 *
 * <h3>WildcardAttributeEvaluator</h3>
 * <p>
 * <strong>Migration:</strong> Use standard pattern matching or regular expressions
 * </p>
 * <p>
 * <strong>Example:</strong> Use FileSystems.getDefault().getPathMatcher("glob:*.txt")
 * </p>
 *
 * <h2>Concurrent Package Utilities (org.mule.runtime.core.api.util.concurrent)</h2>
 *
 * <h3>FunctionalReadWriteLock</h3>
 * <p>
 * <strong>Migration:</strong> Use standard {@link java.util.concurrent.locks.ReadWriteLock}
 * </p>
 * <p>
 * <strong>Note:</strong> Deprecated due to performance overhead - use manual lock management
 * </p>
 *
 * <h3>NamedThreadFactory</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.mule.runtime.api.scheduler.SchedulerService} or implement custom
 * ThreadFactory
 * </p>
 *
 * <h2>Compression Package Utilities (org.mule.runtime.core.api.util.compression)</h2>
 *
 * <h3>CompressionStrategy</h3>
 * <p>
 * <strong>Migration:</strong> Use standard Java compression APIs directly
 * </p>
 *
 * <h3>GZipCompression</h3>
 * <p>
 * <strong>Note:</strong> Throws UnsupportedOperationException when running with Java 21+
 * </p>
 * <p>
 * <strong>Migration:</strong> Use standard {@link java.util.zip.GZIPOutputStream} and
 * {@link java.util.zip.GZIPInputStream}
 * </p>
 *
 * <h3>InvalidZipFileException</h3>
 * <p>
 * <strong>Migration:</strong> Use standard {@link java.util.zip.ZipException} or create custom exception
 * </p>
 *
 * <h2>Functional Programming Utilities (org.mule.runtime.core.api.util.func)</h2>
 *
 * <h3>CheckedConsumer, CheckedFunction, CheckedSupplier, etc.</h3>
 * <p>
 * <strong>Migration:</strong> Use standard Java functional interfaces with proper exception handling
 * </p>
 *
 * <h3>Once</h3>
 * <p>
 * <strong>Migration:</strong> Copy the utility class or implement similar functionality using AtomicBoolean
 * </p>
 *
 * <h3>CompositePredicate</h3>
 * <p>
 * <strong>Migration:</strong> Use standard {@link java.util.function.Predicate} composition with and() method
 * </p>
 *
 * <h2>Proxy Package Utilities (org.mule.runtime.core.api.util.proxy)</h2>
 *
 * <h3>TargetInvocationHandler</h3>
 * <p>
 * <strong>Migration:</strong> Use the new XA connection provider introduced in 4.10 or implement custom
 * InvocationHandler
 * </p>
 *
 * <h2>XML Security Package Utilities (org.mule.runtime.core.api.util.xmlsecurity)</h2>
 *
 * <h3>XMLSecureFactories</h3>
 * <p>
 * <strong>Migration:</strong> Use {@link org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories}
 * </p>
 *
 * <h2>General Migration Notes</h2>
 *
 * <h3>Java Version Compatibility</h3>
 * <ul>
 * <li><strong>Module System:</strong> All deprecated utilities are located in the
 * {@code org.mule.runtime.core.utils} module</li>
 * <li><strong>Dependencies:</strong> The migration alternatives often require additional dependencies like Apache
 * Commons Lang3, Commons IO, or Commons Collections</li>
 * </ul>
 *
 * <h3>Performance Considerations</h3>
 * <ul>
 * <li><strong>FunctionalReadWriteLock:</strong> Deprecated due to performance overhead - use manual lock
 * management</li>
 * <li><strong>NamedThreadFactory:</strong> Use SchedulerService for better integration with Mule's threading
 * model</li>
 * </ul>
 *
 * <h3>Security Considerations</h3>
 * <ul>
 * <li><strong>XMLSecureFactories:</strong> Always use secure XML factories to prevent XXE attacks</li>
 * <li><strong>ClassUtils:</strong> Be mindful of class loading security when migrating to standard reflection</li>
 * </ul>
 *
 * @since 4.11
 *
 * @deprecated See each member deprecation notice.
 */
@Deprecated(since = "4.10", forRemoval = true)
module org.mule.runtime.core.utils {

  requires org.mule.sdk.api;
  requires org.mule.runtime.metadata.model.java;
  requires transitive org.mule.runtime.core;
  requires org.mule.runtime.errors;

  requires org.apache.commons.io;
  requires org.apache.commons.lang3;
  requires uuid;

  exports org.mule.runtime.core.api.util;
  exports org.mule.runtime.core.api.util.concurrent;
  exports org.mule.runtime.core.api.util.compression;
  exports org.mule.runtime.core.api.util.func;
  exports org.mule.runtime.core.api.util.proxy;
  exports org.mule.runtime.core.api.util.xmlsecurity;

}
