/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamProvider;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;
import org.mule.runtime.core.api.streaming.object.InMemoryCursorIteratorConfig;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.streaming.StreamingUtils;
import org.mule.runtime.core.internal.streaming.bytes.ByteArrayCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.bytes.SimpleByteBufferManager;
import org.mule.runtime.core.internal.streaming.object.InMemoryCursorIteratorProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="Streaming")
@Story(value="Streaming")
public class StreamingUtilsTestCase
extends AbstractMuleTestCase {
    private static final List<String> TEST_LIST = Arrays.asList("Apple", "Banana", "Kiwi");

    @Test
    @Description(value="Test that repeatable stream in the payload is consumed into another fully in memory stream provider")
    public void consumeRepeatableInputStreamPayload() throws Exception {
        CursorStreamProvider payload = this.asCursorProvider("test");
        CoreEvent event = StreamingUtils.consumeRepeatablePayload((CoreEvent)this.getEventBuilder().message(Message.of((Object)payload)).build());
        this.assertConsumedRepeatableInputStream(payload, event);
    }

    @Test
    @Description(value="Test that repeatable stream in the typed value is consumed into another fully in memory stream provider")
    public void consumeRepeatableInputStreamTypedValue() throws Exception {
        CursorStreamProvider payload = this.asCursorProvider("test");
        TypedValue consumed = StreamingUtils.consumeRepeatableValue((TypedValue)TypedValue.of((Object)payload));
        this.assertConsumedRepeatableInputStream(payload, consumed);
    }

    @Test
    @Description(value="Test that repeatable stream in the payload is consumed into another fully in memory stream provider while maintaining the original media type")
    public void consumeJsonRepeatableInputStreamPayload() throws Exception {
        CursorStreamProvider payload = this.asCursorProvider("test");
        CoreEvent event = StreamingUtils.consumeRepeatablePayload((CoreEvent)this.getEventBuilder().message(Message.builder().payload(TypedValue.of((Object)payload)).mediaType(MediaType.APPLICATION_JSON).build()).build());
        this.assertConsumedRepeatableInputStream(payload, event);
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JSON));
    }

    @Test
    @Description(value="Test that repeatable stream in the typed value is consumed into another fully in memory stream provider while maintaining the original media type")
    public void consumeJsonRepeatableInputStreamTypedValue() throws Exception {
        CursorStreamProvider payload = this.asCursorProvider("test");
        TypedValue original = new TypedValue((Object)payload, DataType.builder().type(payload.getClass()).mediaType(MediaType.APPLICATION_JSON).build());
        TypedValue consumed = StreamingUtils.consumeRepeatableValue((TypedValue)original);
        this.assertConsumedRepeatableInputStream(payload, consumed);
        MatcherAssert.assertThat((Object)consumed.getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JSON));
    }

    @Test
    @Description(value="Test that repeatable iterator is consumed into a list")
    public void consumeRepeatableIteratorPayload() throws Exception {
        CursorIteratorProvider payload = this.asCursorProvider(TEST_LIST);
        CoreEvent event = StreamingUtils.consumeRepeatablePayload((CoreEvent)this.getEventBuilder().message(Message.of((Object)payload)).build());
        this.assertConsumedObjectStream(payload, event);
    }

    @Test
    @Description(value="Test that repeatable iterator in typed value is consumed into a list")
    public void consumeRepeatableIteratorTypedValue() throws Exception {
        CursorIteratorProvider payload = this.asCursorProvider(TEST_LIST);
        TypedValue consumed = StreamingUtils.consumeRepeatableValue((TypedValue)TypedValue.of((Object)payload));
        this.assertConsumedObjectStream(payload, consumed);
    }

    @Test
    @Description(value="Test that repeatable iterator is consumed into a list while maintaining the collection data type")
    public void consumeTypedRepeatableIteratorPayload() throws Exception {
        CursorIteratorProvider payload = this.asCursorProvider(TEST_LIST);
        DataType dataType = DataType.builder().collectionType(ArrayList.class).itemType(String.class).build();
        CoreEvent event = StreamingUtils.consumeRepeatablePayload((CoreEvent)this.getEventBuilder().message(Message.builder().payload(new TypedValue((Object)payload, dataType)).build()).build());
        this.assertConsumedObjectStream(payload, event);
        dataType = event.getMessage().getPayload().getDataType();
        MatcherAssert.assertThat((Object)dataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CollectionDataType.class)));
        MatcherAssert.assertThat((Object)((CollectionDataType)dataType).getItemDataType(), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
    }

    @Test
    @Description(value="Test that repeatable iterator in typed value is consumed into a list while maintaining the collection data type")
    public void consumeTypedRepeatableIteratorTypedValue() throws Exception {
        CursorIteratorProvider payload = this.asCursorProvider(TEST_LIST);
        TypedValue original = new TypedValue((Object)payload, DataType.builder().collectionType(ArrayList.class).itemType(String.class).build());
        TypedValue consumed = StreamingUtils.consumeRepeatableValue((TypedValue)original);
        this.assertConsumedObjectStream(payload, consumed);
        DataType dataType = consumed.getDataType();
        MatcherAssert.assertThat((Object)dataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CollectionDataType.class)));
        MatcherAssert.assertThat((Object)((CollectionDataType)dataType).getItemDataType(), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
    }

    @Test
    @Description(value="Test that event without repeatable stream payload is not modified")
    public void dontConsumeUnrepeatableInputStreamPayload() throws Exception {
        CoreEvent event = this.getEventBuilder().message(Message.of((Object)"test")).build();
        MatcherAssert.assertThat((Object)StreamingUtils.consumeRepeatablePayload((CoreEvent)event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)event)));
    }

    @Test
    @Description(value="Test that typed value without repeatable stream payload is not modified")
    public void dontConsumeUnrepeatableInputStreamTypedValue() throws Exception {
        TypedValue value = TypedValue.of((Object)"test");
        MatcherAssert.assertThat((Object)StreamingUtils.consumeRepeatableValue((TypedValue)value), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    @Description(value="Test that event without repeatable iterator payload is not modified")
    public void dontConsumeUnrepeatableIteratorPayload() throws Exception {
        CoreEvent event = this.getEventBuilder().message(Message.of(TEST_LIST)).build();
        MatcherAssert.assertThat((Object)StreamingUtils.consumeRepeatablePayload((CoreEvent)event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)event)));
    }

    @Test
    @Description(value="Test that typed value without repeatable iterator payload is not modified")
    public void dontConsumeUnrepeatableIteratorTypedValue() throws Exception {
        TypedValue value = TypedValue.of(TEST_LIST);
        MatcherAssert.assertThat((Object)StreamingUtils.consumeRepeatableValue((TypedValue)value), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void consumeEventWithNullPayload() throws Exception {
        CoreEvent event = this.getEventBuilder().message(Message.of(null)).build();
        MatcherAssert.assertThat((Object)StreamingUtils.consumeRepeatablePayload((CoreEvent)event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)event)));
    }

    @Test
    public void consumeNullTypedValue() throws Exception {
        TypedValue value = TypedValue.of(null);
        MatcherAssert.assertThat((Object)StreamingUtils.consumeRepeatableValue((TypedValue)value), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    private void assertConsumedRepeatableInputStream(CursorStreamProvider payload, CoreEvent event) {
        this.assertConsumedRepeatableInputStream(payload, event.getMessage().getPayload());
    }

    private void assertConsumedRepeatableInputStream(CursorStreamProvider payload, TypedValue value) {
        Object responsePayload = value.getValue();
        MatcherAssert.assertThat((Object)responsePayload, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)payload))));
        MatcherAssert.assertThat((Object)responsePayload, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ByteArrayCursorStreamProvider.class)));
        MatcherAssert.assertThat((Object)IOUtils.toString((CursorStreamProvider)((CursorStreamProvider)responsePayload)), (Matcher)CoreMatchers.equalTo((Object)"test"));
    }

    private void assertConsumedObjectStream(CursorIteratorProvider payload, CoreEvent event) {
        this.assertConsumedObjectStream(payload, event.getMessage().getPayload());
    }

    private void assertConsumedObjectStream(CursorIteratorProvider payload, TypedValue value) {
        Object responsePayload = value.getValue();
        MatcherAssert.assertThat((Object)responsePayload, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)payload))));
        MatcherAssert.assertThat((Object)responsePayload, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(List.class)));
        MatcherAssert.assertThat((Object)responsePayload, (Matcher)CoreMatchers.equalTo(TEST_LIST));
    }

    private CursorStreamProvider asCursorProvider(String value) {
        return new InMemoryCursorStreamProvider((InputStream)new ByteArrayInputStream(value.getBytes()), InMemoryCursorStreamConfig.getDefault(), (ByteBufferManager)new SimpleByteBufferManager());
    }

    private <T> CursorIteratorProvider asCursorProvider(List<T> list) {
        StreamingIterator iterator = (StreamingIterator)Mockito.mock(StreamingIterator.class);
        Iterator original = list.iterator();
        Mockito.when((Object)iterator.hasNext()).thenAnswer(i -> original.hasNext());
        Mockito.when((Object)iterator.next()).thenAnswer(i -> original.next());
        return new InMemoryCursorIteratorProvider((Iterator)iterator, InMemoryCursorIteratorConfig.getDefault());
    }
}

