/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.xmlsecurity;

import javax.xml.parsers.DocumentBuilderFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;

public class XMLSecureFactoriesTestCase {
    @Test
    public void createsTheCorrectInstances() {
        XMLSecureFactories xmlSecureFactories = XMLSecureFactories.createDefault();
        Assert.assertThat((Object)xmlSecureFactories.getDocumentBuilderFactory(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)xmlSecureFactories.getSAXParserFactory(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)xmlSecureFactories.getXMLInputFactory(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)xmlSecureFactories.getTransformerFactory(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void cachesXmlFactory() {
        DocumentBuilderFactory documentBuilderFactoryOne = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        DocumentBuilderFactory documentBuilderFactoryTwo = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        Assert.assertThat((Object)documentBuilderFactoryOne, (Matcher)Matchers.sameInstance((Object)documentBuilderFactoryTwo));
    }

    @Test
    public void handlesDifferentConfigurations() {
        DocumentBuilderFactory insecureFactoryOne = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)true).getDocumentBuilderFactory();
        DocumentBuilderFactory secureFactoryOne = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)false).getDocumentBuilderFactory();
        DocumentBuilderFactory insecureFactoryTwo = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)true).getDocumentBuilderFactory();
        DocumentBuilderFactory secureFactoryTwo = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)false).getDocumentBuilderFactory();
        Assert.assertThat((Object)insecureFactoryOne, (Matcher)Matchers.sameInstance((Object)insecureFactoryTwo));
        Assert.assertThat((Object)secureFactoryOne, (Matcher)Matchers.sameInstance((Object)secureFactoryTwo));
        Assert.assertThat((Object)insecureFactoryOne, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)secureFactoryOne)));
    }
}

