/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.core.api.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

/*
* @deprecated use {@link org.mule.runtime.core.internal.util.NetworkUtils} instead.
*/
@Deprecated(since = "4.10", forRemoval = true)
public final class NetworkUtils {

  private NetworkUtils() {
    // utility class only
  }

  public static InetAddress getLocalHost() throws UnknownHostException {
    return org.mule.runtime.core.internal.util.NetworkUtils.getLocalHost();
  }

  /**
   * Resolves a local IP for a host name.
   *
   * This method should not be used to resolve external host ips since it has a cache that can grow indefinitely.
   *
   * For performance reasons returns the ip and not the {@link java.net.InetAddress} since the {@link java.net.InetAddress}
   * performs logic each time it has to resolve the host address.
   *
   * @param host the host name
   * @return the host ip
   * @throws UnknownHostException
   */
  public static String getLocalHostIp(String host) throws UnknownHostException {
    return org.mule.runtime.core.internal.util.NetworkUtils.getLocalHostIp(host);
  }

  /**
   * Resolves a local IP for a host name.
   *
   * This method should not be used to resolve external host ips since it has a cache that can grow indefinitely.
   *
   * For performance reasons returns the ip and not the {@link java.net.InetAddress} since the {@link java.net.InetAddress}
   * performs logic each time it has to resolve the host address.
   *
   * @param host the host name
   * @return the host ip
   * @throws UnknownHostException
   */
  public static InetAddress getLocalHostAddress(String host) throws UnknownHostException {
    return org.mule.runtime.core.internal.util.NetworkUtils.getLocalHostAddress(host);
  }
}
