/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StringMessageUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void toStringOnStringShouldReturnTheString() {
        String input = "Oscar";
        String result = StringMessageUtils.toString((Object)input);
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void toStringOnClassShouldReturnClassName() {
        Class<?> test = ((Object)((Object)this)).getClass();
        String result = StringMessageUtils.toString(test);
        Assert.assertEquals((Object)((Object)((Object)this)).getClass().getName(), (Object)result);
    }

    @Test
    public void toStringOnObjectShouldReturnObjectsToStringRepresentation() {
        TestObject test = new TestObject("Ernie");
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)test.toString(), (Object)result);
        test = new AnotherTestObject("Bert");
        result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"Bert", (Object)result);
    }

    @Test
    public void toStringOnStringArrayShouldReturnStringRepresentation() {
        String[] test = new String[]{"foo", "bar"};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{foo,bar}", (Object)result);
    }

    @Test
    public void toStringOnByteArrayShouldReturnStringRepresentation() {
        byte[] test = new byte[]{1, 2};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{1,2}", (Object)result);
    }

    @Test
    public void toStringOnByteArrayLargerThanMaximumOutputLengthShouldReturnAbbreviatedStringRepresentation() {
        byte[] test = new byte[150];
        for (int i = 0; i < test.length; ++i) {
            test[i] = (byte)i;
        }
        String result = StringMessageUtils.toString((Object)test);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.endsWith((String)"[..]}"));
        Assert.assertEquals((long)49L, (long)StringUtils.countMatches((CharSequence)result, (CharSequence)","));
    }

    @Test
    public void toStringOnLongArrayShouldReturnStringRepresentation() {
        long[] test = new long[]{5068875495743534L, 457635546759674L};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{5068875495743534,457635546759674}", (Object)result);
    }

    @Test
    public void toStringOnDoubleArrayShouldReturnStringRepresentation() {
        double[] test = new double[]{1.1, 2.02};
        String result = StringMessageUtils.toString((Object)test);
        Assert.assertEquals((Object)"{1.1,2.02}", (Object)result);
    }

    @Test
    public void toStringOnListLargerThanMaximumOutputLengthShouldReturnAbbreviatedStringRepresentation() {
        ArrayList<Integer> list = new ArrayList<Integer>(100);
        for (int i = 0; i < 100; ++i) {
            list.add(i);
        }
        String result = StringMessageUtils.toString(list);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.endsWith((String)"[..]]"));
        Assert.assertEquals((long)49L, (long)StringUtils.countMatches((CharSequence)result, (CharSequence)","));
    }

    @Test
    public void testBoilerPlateSingleLine() {
        String plate = StringMessageUtils.getBoilerPlate((String)"Single message.", (char)'*', (int)12);
        Assert.assertEquals((Object)(System.lineSeparator() + "************" + System.lineSeparator() + "* Single   *" + System.lineSeparator() + "* message. *" + System.lineSeparator() + "************"), (Object)plate);
    }

    @Test
    public void testBoilerPlate() throws Exception {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("This");
        msgs.add("is a");
        msgs.add("Boiler Plate");
        String plate = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)12);
        Assert.assertEquals((Object)(System.lineSeparator() + "************" + System.lineSeparator() + "* This     *" + System.lineSeparator() + "* is a     *" + System.lineSeparator() + "* Boiler   *" + System.lineSeparator() + "* Plate    *" + System.lineSeparator() + "************"), (Object)plate);
    }

    @Test
    public void testBoilerPlate2() throws Exception {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("This");
        msgs.add("is a");
        msgs.add("Boiler Plate Message that should get wrapped to the next line if it is working properly");
        String plate = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)12);
        Assert.assertEquals((Object)(System.lineSeparator() + "************" + System.lineSeparator() + "* This     *" + System.lineSeparator() + "* is a     *" + System.lineSeparator() + "* Boiler   *" + System.lineSeparator() + "* Plate    *" + System.lineSeparator() + "* Message  *" + System.lineSeparator() + "* that     *" + System.lineSeparator() + "* should   *" + System.lineSeparator() + "* get      *" + System.lineSeparator() + "* wrapped  *" + System.lineSeparator() + "* to the   *" + System.lineSeparator() + "* next     *" + System.lineSeparator() + "* line if  *" + System.lineSeparator() + "* it is    *" + System.lineSeparator() + "* working  *" + System.lineSeparator() + "* properly *" + System.lineSeparator() + "************"), (Object)plate);
    }

    @Test
    public void testTruncate() {
        String msg = "this is a test message for truncating";
        String result = StringMessageUtils.truncate((String)msg, (int)100, (boolean)true);
        Assert.assertEquals((Object)msg, (Object)result);
        result = StringMessageUtils.truncate((String)msg, (int)10, (boolean)false);
        Assert.assertEquals((Object)"this is a ...", (Object)result);
        result = StringMessageUtils.truncate((String)msg, (int)10, (boolean)true);
        Assert.assertEquals((Object)"this is a ...[10 of 37]", (Object)result);
    }

    private class TestObject {
        private final String myName;

        public TestObject(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }
    }

    private class AnotherTestObject
    extends TestObject {
        public AnotherTestObject(String name) {
            super(name);
        }

        public String toString() {
            return this.getName();
        }
    }
}

