/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal;

import static com.google.common.base.Preconditions.checkArgument;
import org.mule.runtime.module.embedded.api.ApplicationConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;

import java.io.File;

/**
 * Default implementation of {@link ApplicationConfiguration.ApplicationConfigurationBuilder}.
 *
 * @since 1.0
 */
public class DefaultArtifactConfigurationBuilder implements ApplicationConfiguration.ApplicationConfigurationBuilder {

  private File applicationLocation;
  private DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().build();

  @Override
  public ApplicationConfiguration.ApplicationConfigurationBuilder withApplicationLocation(File applicationLocation) {
    this.applicationLocation = applicationLocation;
    return this;
  }

  @Override
  public ApplicationConfiguration.ApplicationConfigurationBuilder withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
    this.deploymentConfiguration = deploymentConfiguration;
    return this;
  }

  @Override
  public ApplicationConfiguration build() {
    return new ApplicationConfigurationImpl(deploymentConfiguration, applicationLocation);
  }

  /**
   * Default implementation for {@link ApplicationConfiguration}
   */
  static class ApplicationConfigurationImpl implements ApplicationConfiguration {

    private DeploymentConfiguration deploymentConfiguration;
    private File applicationLocation;

    public ApplicationConfigurationImpl(DeploymentConfiguration deploymentConfiguration, File applicationLocation) {
      checkArgument(deploymentConfiguration != null, "deploymentConfiguration cannot be null");
      checkArgument(applicationLocation != null, "applicationLocation cannot be null");
      this.deploymentConfiguration = deploymentConfiguration;
      this.applicationLocation = applicationLocation;
    }

    @Override
    public DeploymentConfiguration getDeploymentConfiguration() {
      return deploymentConfiguration;
    }

    @Override
    public File getApplicationLocation() {
      return applicationLocation;
    }

  }
}
