/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal;

import static org.mule.maven.client.api.util.Preconditions.checkNotNull;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Default implementation of {@link org.mule.runtime.module.embedded.api.ContainerConfiguration.ContainerConfigurationBuilder}
 * 
 * @since 1.0
 */
public class DefaultContainerConfigurationBuilder implements ContainerConfiguration.ContainerConfigurationBuilder {

  private File containerFolder;
  private List<BundleDescriptor> bundleDescriptors = new ArrayList<>();

  @Override
  public ContainerConfiguration.ContainerConfigurationBuilder withContainerFolder(File containerFolder) {
    this.containerFolder = containerFolder;
    return this;
  }

  @Override
  public ContainerConfiguration.ContainerConfigurationBuilder withServerPlugin(BundleDescriptor... bundleDescriptors) {
    this.bundleDescriptors = Arrays.asList(bundleDescriptors);
    return this;
  }

  @Override
  public ContainerConfiguration build() {
    return new ContainerConfigurationImpl(containerFolder, bundleDescriptors);
  }

  public static class ContainerConfigurationImpl implements ContainerConfiguration {

    private File containerFolder;
    private List<BundleDescriptor> serverPlugins;

    public ContainerConfigurationImpl(File containerFolder, List<BundleDescriptor> serverPlugins) {
      checkNotNull(containerFolder, "containerFolder cannot be null");
      checkNotNull(serverPlugins, "serverPlugins cannot be null");
      this.containerFolder = containerFolder;
      this.serverPlugins = serverPlugins;
    }

    @Override
    public File getContainerFolder() {
      return this.containerFolder;
    }

    @Override
    public List<BundleDescriptor> getServerPlugins() {
      return this.serverPlugins;
    }
  }


}
