/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.Product;

public class MavenContainerClassLoaderFactory {
    private final MavenClient mavenClient;

    public MavenContainerClassLoaderFactory(MavenClient mavenClient) {
        this.mavenClient = mavenClient;
    }

    public ClassLoader create(String version, Product product, ClassLoader parentClassLoader, URL containerBaseFolder) {
        try {
            BundleDescriptor containerBomBundleDescriptor = this.getContainerBomBundleDescriptor(version, product);
            List bundleDependencies = this.mavenClient.resolveBundleDescriptorDependencies(false, containerBomBundleDescriptor);
            List<URL> urls = bundleDependencies.stream().filter(bundleDependency -> !bundleDependency.getDescriptor().getGroupId().equals("org.mule.services")).map(dep -> {
                try {
                    return dep.getBundleUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            urls = new ArrayList(urls);
            File containerFolderFile = FileUtils.toFile((URL)containerBaseFolder);
            urls.add(new URL(new File(containerFolderFile, "conf").toURI().toString() + "/"));
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<URL> getServices(String version, Product product) {
        BundleDescriptor containerBomBundleDescriptor = this.getContainerBomBundleDescriptor(version, product);
        List containerDependencies = this.mavenClient.resolveBundleDescriptorDependencies(false, containerBomBundleDescriptor);
        List urls = containerDependencies.stream().map(dep -> {
            try {
                return dep.getBundleUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return urls.stream().filter(u -> this.isService((URL)u)).collect(Collectors.toList());
    }

    private boolean isService(URL url) {
        String fileName = FileUtils.toFile((URL)url).getPath().toLowerCase();
        return fileName.endsWith(".zip") || fileName.endsWith("-mule-service.jar");
    }

    private BundleDescriptor getContainerBomBundleDescriptor(String version, Product product) {
        return new BundleDescriptor.Builder().setGroupId(product.equals((Object)Product.MULE) ? "org.mule.distributions" : "com.mulesoft.mule.distributions").setArtifactId(product.equals((Object)Product.MULE) ? "mule-runtime-impl-bom" : "mule-runtime-impl-bom").setVersion(version).setType("pom").build();
    }
}

