/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

import org.mule.runtime.module.embedded.internal.DefaultDeploymentConfigurationBuilder;

import java.io.Serializable;

/**
 * Specific deployment configuration for the artifact. This deployment configuration overrides default deployment configuration
 * for the artifact.
 *
 * @since 1.0
 */
public interface DeploymentConfiguration extends Serializable {

  /**
   * @return {@code true} if the artifact context will be created a lazily, {@code false} otherwise.
   */
  boolean lazyInitializationEnabled();

  /**
   * @return {@code true} if the artifact will be deployed with XSD validations, {@code false} otherwise.
   */
  boolean xmlValidationsEnabled();

  /**
   * @return a new builder for the {@link DeploymentConfiguration}
   */
  static DeploymentConfigurationBuilder builder() {
    return new DefaultDeploymentConfigurationBuilder();
  }

  /**
   * Builder interface for {@link DeploymentConfiguration}. Instances must be created using
   * {@link DeploymentConfiguration#builder()} method.
   */
  interface DeploymentConfigurationBuilder {

    /**
     * When an artifact context is lazily created then not all components will be created during the creation of the
     * artifact. Only the minimum set of required components will be created upon request of functionality. By default
     * initialization is not lazy.
     *
     * @return same builder
     */
    DeploymentConfigurationBuilder lazyInitialization(boolean enabled);

    /**
     * Allows to enable or disable XML validations while deploying the artifact. By default validations are enabled.
     *
     * @return same builder
     */
    DeploymentConfigurationBuilder xmlValidations(boolean enabled);

    /**
     * @return builds a {@link DeploymentConfiguration} deployment configuration instance with the provided configuration.
     */
    DeploymentConfiguration build();

  }

}
