/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

/**
 * API for embedded Mule Runtime.
 *
 * @moduleGraph
 * @since 1.5
 */
module org.mule.runtime.embedded.api {

  requires transitive org.mule.runtime.maven.client.api;
  requires transitive org.mule.runtime.maven.pom.parser.api;

  requires org.mule.runtime.api.annotations;
  requires org.mule.runtime.embedded.commons;

  requires com.google.gson;
  requires java.management;
  requires org.apache.commons.io;
  requires org.apache.commons.lang3;
  requires org.slf4j;
  requires semver4j;

  exports org.mule.runtime.module.embedded.api;
  exports org.mule.runtime.module.embedded.api.controller;
  // TODO - remove once Java 8 support ended
  exports org.mule.runtime.module.embedded.internal.controller;
  exports org.mule.runtime.module.embedded.api.dependencies;

  exports org.mule.runtime.module.embedded.internal.classloading to
      org.mule.distribution.embedded.test.helper,
      org.mule.runtime.embedded.api.test;

  exports org.mule.runtime.module.embedded.internal to
      org.mule.runtime.embedded.api.test;
  exports org.mule.runtime.module.embedded.internal.dependencies to
      org.mule.runtime.embedded.api.test;
  exports org.mule.runtime.module.embedded.internal.jvm to
      org.mule.runtime.embedded.api.test;
  exports org.mule.runtime.module.embedded.internal.utils to
      org.mule.runtime.embedded.api.test;

  uses org.mule.runtime.module.embedded.api.controller.EmbeddedControllerProvider;
  // TODO - remove once Java 8 support ended
  uses org.mule.runtime.module.embedded.internal.controller.EmbeddedControllerProvider;

}
