/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

import org.mule.api.annotation.NoImplement;

/**
 * Embedded container deployment service.
 *
 * @since 1.0
 */
@NoImplement
public interface DeploymentService {

  /**
   * @param artifactConfiguration application to be deployed
   */
  void deployApplication(ArtifactConfiguration artifactConfiguration);

  /**
   * @param applicationName name of the application to be undeploy. The application name will be the one of the artifact folder or
   *                        the packaged artifact with the extension.
   */
  void undeployApplication(String applicationName);

  /**
   * @param artifactConfiguration application to be deployed
   */
  void deployDomain(ArtifactConfiguration artifactConfiguration);

  /**
   * @param applicationName name of the application to be undeploy. The application name will be the one of the artifact folder or
   *                        the packaged artifact with the extension.
   */
  void undeployDomain(String applicationName);



}
