/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal.dependencies;

import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.dependencies.DependencyResolver;

import java.util.List;

public class DefaultDependencyResolver implements DependencyResolver {

  private final MavenClient mavenClient;

  public DefaultDependencyResolver(MavenClient mavenClient) {
    this.mavenClient = mavenClient;
  }

  @Override
  public List<BundleDependency> resolveBundleDescriptorDependencies(BundleDescriptor descriptor) {
    return mavenClient.resolveBundleDescriptorDependencies(false, descriptor);
  }

  @Override
  public BundleDependency resolveBundleDescriptor(BundleDescriptor descriptor) {
    return mavenClient.resolveBundleDescriptor(descriptor);
  }

}
