/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal.legacy;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

import org.apache.commons.lang3.SerializationUtils;

/**
 * Serializer for passing objects to embedded controller.
 *
 * @since 4.0
 */
public class Serializer {

  private Serializer() {}

  public static void serialize(Serializable obj, OutputStream outputStream) {
    SerializationUtils.serialize(obj, outputStream);
    if (outputStream == null) {
      throw new IllegalArgumentException("The OutputStream must not be null");
    }
    try (ObjectOutputStream out = new ObjectOutputStream(outputStream)) {
      out.writeObject(obj);
    } catch (IOException ex) {
      throw new IllegalStateException(ex);
    }
  }
}
