/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal;

import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.controller.EmbeddedController;
import org.mule.runtime.module.embedded.api.controller.EmbeddedControllerProvider;

import java.net.URL;
import java.util.List;

/**
 * Default implementation of {@link EmbeddedContainer}.
 */
public class DefaultEmbeddedContainer extends AbstractEmbeddedContainer<EmbeddedController> {

  public DefaultEmbeddedContainer(String muleVersion, ContainerConfiguration containerConfiguration,
                                  ClassLoader containerModulesClassLoader, List<URL> services, List<URL> serverPlugins,
                                  URL containerBaseFolder, MavenClient mavenClient) {
    super(muleVersion, containerConfiguration, containerModulesClassLoader, services, serverPlugins, containerBaseFolder,
          mavenClient);
  }

  @Override
  protected EmbeddedController getEmbeddedController(ClassLoader embeddedControllerBootstrapClassLoader,
                                                     ContainerInfo containerInfo) {
    return EmbeddedControllerProvider.discoverProvider(embeddedControllerBootstrapClassLoader)
        .createEmbeddedController(containerInfo);
  }

  @Override
  protected void startEmbeddedController(EmbeddedController embeddedController) {
    executeUsingExecutorService(() -> {
      embeddedController.start();
      return null;
    });
  }

  @Override
  protected void stopEmbeddedController(EmbeddedController embeddedController) {
    executeUsingExecutorService(() -> {
      embeddedController.stop();
      return null;
    });
  }

  @Override
  public DeploymentService doGetDeploymentService(EmbeddedController embeddedController) {
    return new DeploymentService() {

      @Override
      public void deployApplication(ArtifactConfiguration artifactConfiguration) {
        executeUsingExecutorService(() -> {
          embeddedController.deployApplication(artifactConfiguration);
          return null;
        });
      }

      @Override
      public void undeployApplication(String applicationName) {
        executeUsingExecutorService(() -> {
          embeddedController.undeployApplication(applicationName);
          return null;
        });
      }

      @Override
      public void deployDomain(ArtifactConfiguration artifactConfiguration) {
        executeUsingExecutorService(() -> {
          embeddedController.deployDomain(artifactConfiguration);
          return null;
        });
      }

      @Override
      public void undeployDomain(String domainName) {
        executeUsingExecutorService(() -> {
          embeddedController.undeployDomain(domainName);
          return null;
        });
      }
    };
  }

}
