/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal;

import org.mule.runtime.module.embedded.api.DeploymentConfiguration;

/**
 * Default implementation of {@link DeploymentConfiguration.DeploymentConfigurationBuilder}.
 *
 * @since 1.0
 */
public class DefaultDeploymentConfigurationBuilder implements DeploymentConfiguration.DeploymentConfigurationBuilder {

  private boolean lazyInitializationEnabled = false;
  private boolean xmlValidationsEnabled = false;
  private boolean lazyConnectionsEnabled = false;
  private boolean addArtifactAstToRegistry = false;

  @Override
  public DeploymentConfiguration.DeploymentConfigurationBuilder lazyInitialization(boolean enabled) {
    lazyInitializationEnabled = enabled;
    return this;
  }

  @Override
  public DeploymentConfiguration.DeploymentConfigurationBuilder xmlValidations(boolean enabled) {
    xmlValidationsEnabled = enabled;
    return this;
  }

  @Override
  public DeploymentConfiguration.DeploymentConfigurationBuilder lazyConnectionsEnabled(boolean enabled) {
    lazyConnectionsEnabled = enabled;
    return this;
  }

  @Override
  public DeploymentConfiguration.DeploymentConfigurationBuilder addArtifactAstToRegistry(boolean addArtifactAstToRegistry) {
    this.addArtifactAstToRegistry = addArtifactAstToRegistry;
    return this;
  }

  @Override
  public DeploymentConfiguration build() {
    return new DeploymentConfigurationImpl(lazyInitializationEnabled, xmlValidationsEnabled, lazyConnectionsEnabled,
                                           addArtifactAstToRegistry);
  }

  static class DeploymentConfigurationImpl implements DeploymentConfiguration {

    private static final long serialVersionUID = 3520767160861854299L;

    private final boolean lazyInitializationEnabled;
    private final boolean xmlValidationsEnabled;
    private final boolean lazyConnectionsEnabled;
    private final boolean addArtifactAstToRegistry;

    public DeploymentConfigurationImpl(boolean lazyInitializationEnabled, boolean xmlValidationsEnabled,
                                       boolean lazyConnectionsEnabled,
                                       boolean addArtifactAstToRegistry) {
      this.lazyInitializationEnabled = lazyInitializationEnabled;
      this.xmlValidationsEnabled = xmlValidationsEnabled;
      this.lazyConnectionsEnabled = lazyConnectionsEnabled;
      this.addArtifactAstToRegistry = addArtifactAstToRegistry;
    }

    @Override
    public boolean lazyInitializationEnabled() {
      return lazyInitializationEnabled;
    }

    @Override
    public boolean xmlValidationsEnabled() {
      return xmlValidationsEnabled;
    }

    @Override
    public boolean lazyConnectionsEnabled() {
      return lazyConnectionsEnabled;
    }

    @Override
    public boolean addArtifactAstToRegistry() {
      return addArtifactAstToRegistry;
    }
  }
}
