/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

/**
 * Enumeration of products available for the embedded container
 *
 * @since 1.0
 */
public enum Product {

  MULE("org.mule.distributions", "mule-runtime-impl-bom"),

  MULE_EE("com.mulesoft.mule.distributions", "mule-runtime-impl-bom"),

  MULE_FRAMEWORK("org.mule.fwk", "mule-framework-bom");

  private String groupId;
  private String artifactId;

  Product(String groupId, String artifactId) {
    this.groupId = groupId;
    this.artifactId = artifactId;
  }

  public String getGroupId() {
    return groupId;
  }

  public String getArtifactId() {
    return artifactId;
  }
}
