/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal.legacy;

import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.controller.EmbeddedController;
import org.mule.runtime.module.embedded.internal.DefaultEmbeddedContainer;
import org.mule.runtime.module.embedded.internal.controller.EmbeddedControllerProvider;

import java.net.URL;
import java.util.List;

public class LegacyDefaultEmbeddedContainer extends DefaultEmbeddedContainer {

  public LegacyDefaultEmbeddedContainer(String muleVersion, ContainerConfiguration containerConfiguration,
                                        ClassLoader containerModulesClassLoader, List<URL> services, URL containerBaseFolder,
                                        MavenClient mavenClient) {
    super(muleVersion, containerConfiguration, containerModulesClassLoader, services, containerBaseFolder, mavenClient);
  }

  @Override
  protected EmbeddedController getEmbeddedController(ClassLoader embeddedControllerBootstrapClassLoader,
                                                     ContainerInfo containerInfo) {
    return EmbeddedControllerProvider.discoverProvider(embeddedControllerBootstrapClassLoader)
        .createEmbeddedController(containerInfo);
  }

}
