/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal.legacy;

import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.internal.ReflectionEmbeddedContainer;

import java.io.Serializable;
import java.net.URL;
import java.util.List;

/**
 * Legacy implementation of {@link EmbeddedContainer} to support {@code mule-module-embedded-impl 4.4.0} and lower.
 */
public class LegacyEmbeddedContainer extends ReflectionEmbeddedContainer {

  public LegacyEmbeddedContainer(String muleVersion, ContainerConfiguration containerConfiguration,
                                 ClassLoader containerModulesClassLoader, List<URL> services, URL containerBaseFolder,
                                 MavenClient mavenClient) {
    super(muleVersion, containerConfiguration, containerModulesClassLoader, services, containerBaseFolder, mavenClient);
  }

  @Override
  protected String getControllerClassName() {
    return "org.mule.runtime.module.embedded.impl.EmbeddedController";
  }

  @Override
  protected Serializable adaptContainerInfo(ContainerInfo containerInfo) {
    // Nothing to adapt
    return containerInfo;
  }

  @Override
  protected Serializable adaptArtifactConfiguration(ArtifactConfiguration artifactConfiguration) {
    // Nothing to adapt
    return artifactConfiguration;
  }
}
