/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal;

import java.lang.reflect.InvocationTargetException;

public class EmbeddedManifest {

  private final Class<?> manifestClass;
  private final Object manifest;

  static EmbeddedManifest getMuleManifest(ClassLoader containerModulesClassLoader) throws ClassNotFoundException {
    try {
      Class<?> manifestClass = containerModulesClassLoader.loadClass("org.mule.runtime.manifest.api.MuleManifest");
      return new EmbeddedManifest(manifestClass, manifestClass.getMethod("getMuleManifest").invoke(null));
    } catch (ClassNotFoundException e) {
      return new EmbeddedManifest(containerModulesClassLoader.loadClass("org.mule.runtime.core.api.config.MuleManifest"));
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  EmbeddedManifest(Class<?> manifestClass) {
    this(manifestClass, null);
  }

  EmbeddedManifest(Class<?> manifestClass, Object manifest) {
    this.manifestClass = manifestClass;
    this.manifest = manifest;
  }

  public String getProductVersion() {
    return invokeMethod("getProductVersion");
  }

  public String getSupportedJdks() {
    return invokeMethod("getSupportedJdks");
  }

  public String getRecommendedJdks() {
    if (manifest != null) {
      return invokeMethod("getRecommendedJdks");
    } else {
      return invokeMethod("getRecommndedJdks");
    }
  }

  private String invokeMethod(String methodName) {
    try {
      if (manifest != null) {
        return (String) manifestClass.getDeclaredMethod(methodName).invoke(manifest);
      } else {
        return (String) manifestClass.getDeclaredMethod(methodName).invoke(null);
      }
    } catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
      throw new RuntimeException(e);
    }
  }

}
