/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.module.embedded.internal.DefaultContainerInformation;

/**
 * Provides information about the container.
 *
 * @since 1.9
 */
@NoImplement
public interface ContainerInformation {

  static ContainerInformation fromContainerClassLoader(ClassLoader muleContainerClassLoader) {
    return new DefaultContainerInformation(muleContainerClassLoader);
  }

  /**
   * @return the version if the Mule runtime this embedded container is running.
   */
  String getMuleContainerVersion();

  /**
   * Queries Java support metadata of the Mule runtime for the version specified by #getMuleContainerVersion() and checks it
   * against the currently running JVM.
   * <p>
   * Implementations are not required to do any kind of caching of the result.
   *
   * @return @{code true} if the version of the currently running JVM is supported.
   */
  boolean isCurrentJvmVersionSupported();

  /**
   * Queries Java support metadata of the Mule runtime for the version specified by #getMuleContainerVersion() and checks it
   * against the currently running JVM.
   * <p>
   * Implementations are not required to do any kind of caching of the result.
   *
   * @return @{code true} if the version of the currently running JVM is recommended.
   */
  boolean isCurrentJvmVersionRecommended();

}
