/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal.utils;

import org.mule.maven.pom.parser.api.model.BundleDependency;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;

/**
 * Utilities to deal with dependencies.
 */
public class DependenciesUtils {

  private DependenciesUtils() {
    // Nothing to do
  }

  public static Function<? super BundleDependency, ? extends URL> dependencyToUrl() {
    return dep -> {
      try {
        return dep.getBundleUri().toURL();
      } catch (MalformedURLException e) {
        throw new RuntimeException(e);
      }
    };
  }

}
