/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

/**
 * Enumeration of products available for the embedded container
 *
 * @since 1.0
 */
public enum Product {

  MULE(new ArtifactCoordinates("org.mule.distributions", "mule-runtime-impl-no-services-bom"),
      new ArtifactCoordinates("org.mule.distributions", "mule-services-all"),
      new ArtifactCoordinates("org.mule.distributions", "mule-runtime-impl-bom")),

  MULE_EE(new ArtifactCoordinates("com.mulesoft.mule.distributions", "mule-runtime-impl-no-services-bom"),
      new ArtifactCoordinates("com.mulesoft.mule.distributions", "mule-services-all"),
      new ArtifactCoordinates("com.mulesoft.mule.distributions", "mule-runtime-impl-bom")),

  MULE_FRAMEWORK(new ArtifactCoordinates("org.mule.fwk", "mule-framework-no-services-bom"),
      new ArtifactCoordinates("org.mule.fwk", "mule-framework-services-bom"));

  private final ArtifactCoordinates containerBomArtifactCoordinates;
  private final ArtifactCoordinates servicesBomArtifactCoordinates;

  private final ArtifactCoordinates deprecatedBomArtifactCoordinates;

  Product(ArtifactCoordinates containerBomArtifactCoordinates,
          ArtifactCoordinates servicesBomArtifactCoordinates) {
    this(containerBomArtifactCoordinates, servicesBomArtifactCoordinates, null);
  }

  Product(ArtifactCoordinates containerBomArtifactCoordinates,
          ArtifactCoordinates servicesBomArtifactCoordinates,
          ArtifactCoordinates deprecatedBomArtifactCoordinates) {
    this.containerBomArtifactCoordinates = containerBomArtifactCoordinates;
    this.servicesBomArtifactCoordinates = servicesBomArtifactCoordinates;

    this.deprecatedBomArtifactCoordinates = deprecatedBomArtifactCoordinates;
  }

  @Deprecated
  public String getGroupId() {
    return deprecatedBomArtifactCoordinates.getGroupId();
  }

  @Deprecated
  public String getArtifactId() {
    return deprecatedBomArtifactCoordinates.getArtifactId();
  }

  /**
   * @return the coordinates of the artifact specifying the Embedded Runtime container dependencies.
   * @since 1.6
   */
  public ArtifactCoordinates getContainerBomArtifactCoordinates() {
    return containerBomArtifactCoordinates;
  }

  /**
   * @return the coordinates of the artifact specifying the Embedded Runtime services dependencies.
   * @since 1.6
   */
  public ArtifactCoordinates getServicesBomArtifactCoordinates() {
    return servicesBomArtifactCoordinates;
  }

  /**
   * @return the coordinates of the artifact specifying the dependencies needed for versions of the Embedded Runtime prior to 4.6.
   * @since 1.6
   * @deprecated will be removed eventually, only kept for supporting product versions prior to 4.6.
   */
  @Deprecated
  public ArtifactCoordinates getDeprecatedBomArtifactCoordinates() {
    return deprecatedBomArtifactCoordinates;
  }

  /**
   * @since 1.6
   */
  public static class ArtifactCoordinates {

    private final String groupId;
    private final String artifactId;

    public ArtifactCoordinates(String groupId, String artifactId) {
      this.groupId = groupId;
      this.artifactId = artifactId;
    }

    public String getGroupId() {
      return groupId;
    }

    public String getArtifactId() {
      return artifactId;
    }

  }

}
