/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal;

import static org.mule.runtime.module.embedded.internal.EmbeddedManifest.getMuleManifest;
import static org.mule.runtime.module.embedded.internal.jvm.JvmVersionIntervalUnion.parse;

import static java.lang.System.getProperty;

import org.mule.runtime.module.embedded.api.ContainerInformation;

public class DefaultContainerInformation implements ContainerInformation {

  private final EmbeddedManifest muleManifest;

  public DefaultContainerInformation(ClassLoader muleContainerClassLoader) {
    muleManifest = getMuleManifest(muleContainerClassLoader);
  }

  @Override
  public String getMuleContainerVersion() {
    return muleManifest.getProductVersion();
  }

  @Override
  public boolean isCurrentJvmVersionSupported() {
    return parse(muleManifest.getSupportedJdks()).includes(getProperty("java.version"));
  }

  @Override
  public boolean isCurrentJvmVersionRecommended() {
    return parse(muleManifest.getRecommendedJdks()).includes(getProperty("java.version"));
  }

}
