/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeVisitor;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.ObjectFieldHandler;
import org.mule.metadata.ast.internal.DefaultObjectFieldHandler;
import org.mule.runtime.ast.internal.ASTParameterizableType;
import org.mule.runtime.ast.internal.ASTType;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;

public final class ExtensionTypeObjectFieldHandler
implements ObjectFieldHandler {
    private ProcessingEnvironment processingEnvironment;

    ExtensionTypeObjectFieldHandler(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public void handle(Element element, ObjectTypeBuilder builder, IntrospectionContext context, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor) {
        if (element instanceof TypeElement) {
            ASTParameterizableType type = new ASTParameterizableType((TypeElement)element, this.processingEnvironment);
            if (type.isSameType(Chain.class)) {
                return;
            }
            List parameters = type.getParameters();
            if (parameters.isEmpty()) {
                this.fallbackToBeanProperties(element, builder, context, typeVisitor);
                return;
            }
            for (ExtensionParameter parameter : parameters) {
                ObjectFieldTypeBuilder fieldBuilder = builder.addField();
                fieldBuilder.key(parameter.getAlias());
                parameter.getElement().ifPresent(e -> this.extractJavadoc(this.processingEnvironment, (Element)e).ifPresent(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).description(arg_0)));
                this.setFieldType(parameter, fieldBuilder, context, typeVisitor);
            }
        }
    }

    private void fallbackToBeanProperties(Element element, ObjectTypeBuilder builder, IntrospectionContext context, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor) {
        if (!element.getKind().equals((Object)ElementKind.INTERFACE)) {
            new DefaultObjectFieldHandler(this.processingEnvironment).handle(element, builder, context, typeVisitor);
        }
    }

    private void setFieldType(ExtensionParameter parameter, ObjectFieldTypeBuilder fieldBuilder, IntrospectionContext context, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor) {
        Type type = parameter.getType();
        Optional optionalElement = type.getElement();
        if (optionalElement.isPresent()) {
            TypeElement typeElement = (TypeElement)optionalElement.get();
            if (context.contains((Element)typeElement)) {
                fieldBuilder.value(context.get((Element)typeElement));
            } else {
                fieldBuilder.value(((ASTType)type).getTypeMirror().accept(typeVisitor, context));
            }
        } else {
            fieldBuilder.value(type.asMetadataType());
        }
    }

    private Optional<String> extractJavadoc(ProcessingEnvironment processingEnv, Element element) {
        String comment = processingEnv.getElementUtils().getDocComment(element);
        if (comment == null || comment.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(comment.trim().replaceAll("\\{@.+ (.+)\\}", "$1"));
    }
}

