/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal.typevisitor;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import org.mule.runtime.ast.extension.internal.typevisitor.TypeIntrospectionResult;

public class MuleTypeVisitor
implements TypeVisitor<TypeIntrospectionResult, TypeIntrospectionResult.Builder> {
    private ProcessingEnvironment processingEnvironment;

    public MuleTypeVisitor(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    @Override
    public TypeIntrospectionResult visit(TypeMirror t, TypeIntrospectionResult.Builder resultBuilder) {
        return null;
    }

    @Override
    public TypeIntrospectionResult visit(TypeMirror t) {
        return null;
    }

    @Override
    public TypeIntrospectionResult visitPrimitive(PrimitiveType t, TypeIntrospectionResult.Builder resultBuilder) {
        return resultBuilder.setType(null, t).build();
    }

    @Override
    public TypeIntrospectionResult visitNull(NullType t, TypeIntrospectionResult.Builder resultBuilder) {
        return null;
    }

    @Override
    public TypeIntrospectionResult visitArray(ArrayType t, TypeIntrospectionResult.Builder resultBuilder) {
        return resultBuilder.setType(null, t).build();
    }

    @Override
    public TypeIntrospectionResult visitDeclared(DeclaredType t, TypeIntrospectionResult.Builder resultBuilder) {
        resultBuilder.setType((TypeElement)t.asElement(), t);
        for (TypeMirror typeMirror : t.getTypeArguments()) {
            TypeIntrospectionResult accept = typeMirror.accept(this, TypeIntrospectionResult.builder());
            resultBuilder.addGenericType(accept);
        }
        return resultBuilder.build();
    }

    @Override
    public TypeIntrospectionResult visitError(ErrorType t, TypeIntrospectionResult.Builder resultBuilder) {
        return null;
    }

    @Override
    public TypeIntrospectionResult visitTypeVariable(TypeVariable t, TypeIntrospectionResult.Builder resultBuilder) {
        TypeMirror typeMirror = t.getUpperBound() == null ? t.getLowerBound() : t.getUpperBound();
        resultBuilder.setType(null, typeMirror);
        return resultBuilder.build();
    }

    @Override
    public TypeIntrospectionResult visitWildcard(WildcardType t, TypeIntrospectionResult.Builder resultBuilder) {
        return resultBuilder.setType(this.processingEnvironment.getElementUtils().getTypeElement(Object.class.getTypeName()), t).build();
    }

    @Override
    public TypeIntrospectionResult visitExecutable(ExecutableType t, TypeIntrospectionResult.Builder resultBuilder) {
        return null;
    }

    @Override
    public TypeIntrospectionResult visitNoType(NoType t, TypeIntrospectionResult.Builder resultBuilder) {
        resultBuilder.setType(this.processingEnvironment.getElementUtils().getTypeElement(Void.class.getTypeName()), t);
        return resultBuilder.build();
    }

    @Override
    public TypeIntrospectionResult visitUnknown(TypeMirror t, TypeIntrospectionResult.Builder resultBuilder) {
        return null;
    }

    @Override
    public TypeIntrospectionResult visitUnion(UnionType t, TypeIntrospectionResult.Builder resultBuilder) {
        return null;
    }

    @Override
    public TypeIntrospectionResult visitIntersection(IntersectionType t, TypeIntrospectionResult.Builder resultBuilder) {
        return null;
    }
}

