/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import org.mule.runtime.ast.extension.internal.ASTType;
import org.mule.runtime.ast.extension.internal.ASTUtils;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;

public abstract class VariableElementAST
implements ExtensionParameter {
    private final VariableElement param;
    private final ProcessingEnvironment processingEnvironment;
    private final ASTUtils astUtils;

    VariableElementAST(VariableElement param, ProcessingEnvironment processingEnvironment) {
        this.param = param;
        this.processingEnvironment = processingEnvironment;
        this.astUtils = new ASTUtils(processingEnvironment);
    }

    public String getName() {
        return this.param.getSimpleName().toString();
    }

    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.param.getAnnotation(annotationClass));
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.param != null && this.param.getAnnotation(annotation) != null;
    }

    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        if (this.isAnnotatedWith(annotationClass)) {
            return Optional.of(this.astUtils.fromAnnotation(annotationClass, this.param));
        }
        return Optional.empty();
    }

    public Stream<Type> getAnnotations() {
        return this.param.getAnnotationMirrors().stream().map(ann -> new ASTType(ann.getAnnotationType(), this.processingEnvironment));
    }

    public ASTType getType() {
        return new ASTType(this.param.asType(), this.processingEnvironment);
    }

    public Optional<VariableElement> getElement() {
        return Optional.of(this.param);
    }
}

