/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.internal.ASTType;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;

public class ASTValueFetcher<A extends Annotation>
implements AnnotationValueFetcher<A> {
    private Class<A> annotationClass;
    private final ProcessingEnvironment processingEnvironment;
    private final Supplier<Optional<AnnotationMirror>> annotationMirrorSupplier;

    ASTValueFetcher(Class<A> annotationClass, Element annotatedElememt, ProcessingEnvironment processingEnvironment) {
        this.annotationClass = annotationClass;
        this.processingEnvironment = processingEnvironment;
        this.annotationMirrorSupplier = () -> ASTValueFetcher.getAnnotationFrom(annotationClass, annotatedElememt, processingEnvironment);
    }

    private ASTValueFetcher(AnnotationMirror annotationMirror, ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.annotationMirrorSupplier = () -> Optional.ofNullable(annotationMirror);
        try {
            this.annotationClass = Class.forName(annotationMirror.getAnnotationType().toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Unable to create Annotation Value Fetcher for Annotation: [%s], it doesn't exist as a Class.", annotationMirror.getAnnotationType().toString()), e);
        }
    }

    public String getStringValue(Function<A, String> function) {
        return (String)this.getConstant(function).getValue();
    }

    public <E> List<E> getArrayValue(Function<A, E[]> function) {
        AnnotationValue annotationValue = (AnnotationValue)this.getObjectValue(function);
        if (annotationValue != null) {
            List array = (List)annotationValue.getValue();
            return array.stream().map(val -> val.getValue()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Type> getClassArrayValue(Function<A, Class[]> function) {
        AnnotationValue value = (AnnotationValue)this.getObjectValue(function);
        if (value != null) {
            List array = (List)value.getValue();
            return array.stream().map(attr -> (DeclaredType)attr.getValue()).map(declaredType -> new ASTType((TypeElement)declaredType.asElement(), this.processingEnvironment)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public ASTType getClassValue(Function<A, Class> function) {
        Object objectValue = this.getObjectValue(function);
        if (objectValue == null) {
            return null;
        }
        return new ASTType((TypeElement)((DeclaredType)((AnnotationValue)objectValue).getValue()).asElement(), this.processingEnvironment);
    }

    public <N extends Number> N getNumberValue(Function<A, N> function) {
        return (N)((Number)this.getConstant(function).getValue());
    }

    public Boolean getBooleanValue(Function<A, Boolean> function) {
        return (Boolean)this.getConstant(function).getValue();
    }

    public <E extends Enum> E getEnumValue(Function<A, E> function) {
        Class<?> annotationClass;
        VariableElement value = (VariableElement)((AnnotationValue)this.getObjectValue(function)).getValue();
        try {
            annotationClass = Class.forName(this.processingEnvironment.getElementUtils().getBinaryName((TypeElement)value.getEnclosingElement()).toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return (E)Enum.valueOf(annotationClass, value.toString());
    }

    public <E extends Annotation> AnnotationValueFetcher<E> getInnerAnnotation(Function<A, E> function) {
        AnnotationValue annotationValue = (AnnotationValue)this.getObjectValue(function);
        return new ASTValueFetcher<A>((AnnotationMirror)annotationValue.getValue(), this.processingEnvironment);
    }

    public <E extends Annotation> List<AnnotationValueFetcher<E>> getInnerAnnotations(Function<A, E[]> function) {
        List annotationMirrors = (List)((AnnotationValue)this.getObjectValue(function)).getValue();
        return annotationMirrors.stream().map(am -> new ASTValueFetcher<A>((AnnotationMirror)am, this.processingEnvironment)).map(fetcher -> fetcher).collect(Collectors.toList());
    }

    private AnnotationValue getConstant(Function function) {
        return (AnnotationValue)this.getObjectValue(function);
    }

    private Object getObjectValue(Function function) {
        return this.getObjectValue(this.annotationClass, function, this.annotationMirrorSupplier);
    }

    private <T> Object getObjectValue(Class<T> annotationClass, Function retrievalValueFunction, Supplier<Optional<AnnotationMirror>> annotationMirror) {
        CountDownLatch latch = new CountDownLatch(1);
        Enhancer enhancer = new Enhancer();
        Reference reference = new Reference();
        enhancer.setSuperclass(annotationClass);
        enhancer.setCallback((Callback)((MethodInterceptor)(o, method, objects, methodProxy) -> {
            if (method.getName().equals("toString")) {
                return "string";
            }
            reference.set(null);
            ((Optional)annotationMirror.get()).ifPresent(annotation -> ASTValueFetcher.getAnnotationElementValue(annotation, method.getName()).ifPresent(arg_0 -> ((Reference)reference).set(arg_0)));
            latch.countDown();
            return null;
        }));
        retrievalValueFunction.apply(enhancer.create());
        return reference.get();
    }

    private static Optional<? extends AnnotationValue> getAnnotationElementValue(AnnotationMirror annotation, String name) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(name)) continue;
            return Optional.of(entry.getValue());
        }
        for (Element element : annotation.getAnnotationType().asElement().getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD) || !element.getSimpleName().toString().equals(name)) continue;
            return Optional.ofNullable(((ExecutableElement)element).getDefaultValue());
        }
        return Optional.empty();
    }

    private static Optional<AnnotationMirror> getAnnotationFrom(Class configurationClass, Element typeElement, ProcessingEnvironment processingEnvironment) {
        TypeElement annotationTypeElement = processingEnvironment.getElementUtils().getTypeElement(configurationClass.getTypeName());
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            TypeMirror obj = annotationTypeElement.asType();
            if (!processingEnvironment.getTypeUtils().isSameType(annotationType, obj)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }
}

