/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.internal.ASTType;
import org.mule.runtime.ast.internal.IntrospectionTypeUtils;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.source.OnBackPressure;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;

class SourceElementAST
extends ASTType
implements SourceElement {
    private LazyValue<List<Type>> sourceGenerics = new LazyValue(() -> IntrospectionTypeUtils.getSuperTypeGenerics(this.typeElement, this.isLegacySource(processingEnvironment, typeElement) ? Source.class : org.mule.sdk.api.runtime.source.Source.class, processingEnvironment).stream().map(type -> new ASTType((TypeMirror)type, processingEnvironment)).collect(Collectors.toList()));

    SourceElementAST(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        super(typeElement, processingEnvironment);
    }

    private boolean isLegacySource(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        return !IntrospectionTypeUtils.isSubType(typeElement, org.mule.sdk.api.runtime.source.Source.class, processingEnvironment);
    }

    public List<Type> getSuperClassGenerics() {
        return (List)this.sourceGenerics.get();
    }

    public Optional<MethodElement> getOnResponseMethod() {
        return this.findMethodAnnotatedWith(OnSuccess.class);
    }

    public Optional<MethodElement> getOnErrorMethod() {
        return this.findMethodAnnotatedWith(OnError.class);
    }

    public Optional<MethodElement> getOnTerminateMethod() {
        return this.findMethodAnnotatedWith(OnTerminate.class);
    }

    public Optional<MethodElement> getOnBackPressureMethod() {
        return this.findMethodAnnotatedWith(OnBackPressure.class);
    }

    private Optional<MethodElement> findMethodAnnotatedWith(Class<? extends Annotation> annotationClass) {
        return this.getMethods().stream().filter(op -> op.isAnnotatedWith(annotationClass)).map(elem -> elem).findFirst();
    }
}

