/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.ast.internal.ASTType;
import org.mule.runtime.ast.internal.ConnectionProviderASTElement;
import org.mule.runtime.ast.internal.FunctionContainerASTElement;
import org.mule.runtime.ast.internal.OperationContainerElementAST;
import org.mule.runtime.ast.internal.SourceElementAST;
import org.mule.runtime.extension.api.annotation.ExpressionFunctions;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.sdk.api.annotation.Sources;

public class ConfigurationASTElement
extends ASTType
implements ConfigurationElement {
    public ConfigurationASTElement(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        super(typeElement, processingEnvironment);
    }

    public List<ConnectionProviderElement> getConnectionProviders() {
        return Stream.concat(this.collectConnectionProviders(ConnectionProviders.class, ConnectionProviders::value), this.collectConnectionProviders(org.mule.sdk.api.annotation.connectivity.ConnectionProviders.class, org.mule.sdk.api.annotation.connectivity.ConnectionProviders::value)).collect(Collectors.toList());
    }

    private <A extends Annotation> Stream<ConnectionProviderElement> collectConnectionProviders(Class<A> annotationType, Function<A, Class[]> extractionFunction) {
        return this.collectElements(annotationType, extractionFunction, element -> new ConnectionProviderASTElement((TypeElement)element.getElement().get(), this.processingEnvironment));
    }

    public List<FunctionContainerElement> getFunctionContainers() {
        return this.getFunctionContainerStream().collect(Collectors.toList());
    }

    public List<SourceElement> getSources() {
        return this.getSourceElementStream().collect(Collectors.toList());
    }

    public List<OperationContainerElement> getOperationContainers() {
        return this.getOperationElementStream().collect(Collectors.toList());
    }

    protected Stream<FunctionContainerElement> getFunctionContainerStream() {
        return Stream.concat(this.collectFunctionElements(ExpressionFunctions.class, ExpressionFunctions::value), this.collectFunctionElements(org.mule.sdk.api.annotation.ExpressionFunctions.class, org.mule.sdk.api.annotation.ExpressionFunctions::value));
    }

    protected Stream<SourceElement> getSourceElementStream() {
        return Stream.concat(this.collectSourceElements(org.mule.runtime.extension.api.annotation.Sources.class, org.mule.runtime.extension.api.annotation.Sources::value), this.collectSourceElements(Sources.class, Sources::value));
    }

    protected Stream<OperationContainerElement> getOperationElementStream() {
        return Stream.concat(this.collectOperationElements(Operations.class, Operations::value), this.collectOperationElements(org.mule.sdk.api.annotation.Operations.class, org.mule.sdk.api.annotation.Operations::value));
    }

    protected <A extends Annotation> Stream<SourceElement> collectSourceElements(Class<A> annotationClass, Function<A, Class[]> extractionFunction) {
        return this.collectElements(annotationClass, extractionFunction, type -> new SourceElementAST((TypeElement)type.getElement().get(), this.processingEnvironment));
    }

    protected <A extends Annotation> Stream<OperationContainerElement> collectOperationElements(Class<A> annotationClass, Function<A, Class[]> extractionFunction) {
        return this.collectElements(annotationClass, extractionFunction, type -> new OperationContainerElementAST((TypeElement)type.getElement().get(), this.processingEnvironment));
    }

    protected <A extends Annotation> Stream<FunctionContainerElement> collectFunctionElements(Class<A> annotationClass, Function<A, Class[]> extractionFunction) {
        return this.collectElements(annotationClass, extractionFunction, type -> new FunctionContainerASTElement((TypeElement)type.getElement().get(), this.processingEnvironment));
    }

    protected <A extends Annotation, T> Stream<T> collectElements(Class<A> annotationClass, Function<A, Class[]> extractionFunction, Function<Type, T> elementFunction) {
        return this.getValueFromAnnotation(annotationClass).map(valueFetcher -> valueFetcher.getClassArrayValue(extractionFunction).stream().map(elementFunction)).orElse(Stream.empty());
    }
}

