/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.extension.internal;

import static java.util.stream.Collectors.toList;
import static javax.lang.model.element.ElementKind.METHOD;

import org.mule.runtime.module.extension.api.loader.java.type.FunctionContainerElement;
import org.mule.runtime.module.extension.api.loader.java.type.FunctionElement;

import java.util.List;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

/**
 * {@link FunctionContainerElement} which works with the Java AST
 *
 * @since 1.0
 */
public class FunctionContainerASTElement extends ASTType implements FunctionContainerElement {

  private final TypeElement typeElement;
  private final ProcessingEnvironment processingEnvironment;

  /**
   * Creates a new {@link org.mule.runtime.module.extension.internal.loader.java.type.ast.FunctionContainerASTElement}
   *
   * @param typeElement           The {@link TypeElement} representing the Java Class which contains DW Functions
   * @param processingEnvironment The AST {@link ProcessingEnvironment}
   */
  FunctionContainerASTElement(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
    super(typeElement, processingEnvironment);
    this.typeElement = typeElement;
    this.processingEnvironment = processingEnvironment;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<FunctionElement> getFunctions() {
    return typeElement.getEnclosedElements()
        .stream()
        .filter(elem -> elem.getKind().equals(METHOD))
        .map(elem -> new FunctionElementAST((ExecutableElement) elem, processingEnvironment))
        .collect(toList());
  }
}
