/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.ast.api.ASTTypeLoader;
import org.mule.metadata.ast.api.ObjectFieldHandler;
import org.mule.metadata.ast.api.TypeUtils;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.extension.internal.ASTUtils;
import org.mule.runtime.ast.extension.internal.ExtensionTypeHandler;
import org.mule.runtime.ast.extension.internal.ExtensionTypeObjectFieldHandler;
import org.mule.runtime.ast.extension.internal.FieldTypeElement;
import org.mule.runtime.ast.extension.internal.IntrospectionTypeUtils;
import org.mule.runtime.ast.extension.internal.MethodElementAST;
import org.mule.runtime.ast.extension.internal.OperationElementAST;
import org.mule.runtime.ast.extension.internal.typevisitor.MuleTypeVisitor;
import org.mule.runtime.ast.extension.internal.typevisitor.TypeIntrospectionResult;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.PropertyElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ASTType
implements Type {
    private final TypeMirror typeMirror;
    private final LazyValue<List<TypeGeneric>> typeGenerics;
    private LazyValue<List<OperationElement>> methods;
    private LazyValue<ClassInformationAnnotation> classInformation;
    final ProcessingEnvironment processingEnvironment;
    final TypeElement typeElement;
    ASTUtils astUtils;
    private ASTTypeLoader typeLoader;

    public ASTType(TypeMirror typeMirror, ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        TypeIntrospectionResult accept = typeMirror.accept(new MuleTypeVisitor(processingEnvironment), TypeIntrospectionResult.builder());
        this.typeElement = accept.getConcreteType();
        this.typeGenerics = new LazyValue(() -> this.toTypeGenerics(accept, processingEnvironment));
        this.typeMirror = typeMirror;
        this.init();
    }

    public ASTType(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.typeElement = typeElement;
        this.typeMirror = typeElement.asType();
        this.typeGenerics = new LazyValue(Collections.emptyList());
        this.init();
    }

    private void init() {
        this.typeLoader = new ASTTypeLoader(this.processingEnvironment, Collections.singletonList(new ExtensionTypeHandler(this.processingEnvironment)), (ObjectFieldHandler)new ExtensionTypeObjectFieldHandler(this.processingEnvironment));
        this.astUtils = new ASTUtils(this.processingEnvironment);
        this.methods = new LazyValue(() -> IntrospectionUtils.getApiMethods((TypeElement)this.typeElement, (ProcessingEnvironment)this.processingEnvironment).stream().map(elem -> new OperationElementAST((ExecutableElement)elem, this.processingEnvironment)).collect(Collectors.toList()));
        this.classInformation = new LazyValue(() -> ClassInformationAnnotationFactory.fromTypeMirror((TypeMirror)this.typeMirror, (ProcessingEnvironment)this.processingEnvironment));
    }

    public Optional<Class<?>> getDeclaringClass() {
        return Optional.empty();
    }

    public String getName() {
        return this.typeElement != null ? this.typeElement.getSimpleName().toString() : this.typeMirror.toString();
    }

    public List<FieldElement> getFields() {
        return IntrospectionUtils.getFields((TypeElement)this.typeElement, (ProcessingEnvironment)this.processingEnvironment).stream().filter(elem -> !elem.getEnclosingElement().asType().toString().startsWith("java.")).map(elem -> new FieldTypeElement((VariableElement)elem, this.processingEnvironment)).collect(Collectors.toList());
    }

    public List<PropertyElement> getProperties() {
        return TypeUtils.getProperties((Element)this.typeElement, (ProcessingEnvironment)this.processingEnvironment).stream().map(property -> {
            PropertyElement.Accessibility accessibility = property.getGetterMethod() != null && property.getSetterMethod() != null ? PropertyElement.Accessibility.READ_WRITE : (property.getGetterMethod() != null && property.getGetterMethod() == null ? PropertyElement.Accessibility.READ_ONLY : PropertyElement.Accessibility.WRITE_ONLY);
            return PropertyElement.builder().type((Type)new ASTType(property.getType(), this.processingEnvironment)).name(property.getBeanName()).accessibility(accessibility).build();
        }).collect(Collectors.toList());
    }

    public List<FieldElement> getAnnotatedFields(Class<? extends Annotation> ... annotations) {
        return this.getFields().stream().filter(elem -> Stream.of(annotations).anyMatch(annotation -> elem.isAnnotatedWith(annotation))).collect(Collectors.toList());
    }

    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        if (this.typeElement == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.typeElement.getAnnotation(annotationClass));
    }

    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        if (this.isAnnotatedWith(annotationClass)) {
            return Optional.of(this.astUtils.fromAnnotation(annotationClass, this.typeElement));
        }
        return Optional.empty();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.typeElement == null ? false : this.typeElement.getAnnotation(annotation) != null;
    }

    public Stream<Type> getAnnotations() {
        return this.typeElement == null ? Stream.empty() : this.typeElement.getAnnotationMirrors().stream().map(ann -> new ASTType(ann.getAnnotationType(), this.processingEnvironment));
    }

    public Optional<TypeElement> getElement() {
        return Optional.ofNullable(this.typeElement);
    }

    public Optional<MethodElement> getMethod(String name, Class<?> ... parameterTypes) {
        Optional<MethodElement> method = IntrospectionUtils.getMethodsStream((TypeElement)this.typeElement, (boolean)true, (ProcessingEnvironment)this.processingEnvironment).map(elem -> new OperationElementAST((ExecutableElement)elem, this.processingEnvironment)).filter(m -> m.getName().equals(name) && m.getParameters().size() == parameterTypes.length && IntStream.range(0, parameterTypes.length).allMatch(index -> m.getParameters().get(index).getType().isSameType(parameterTypes[index]))).findFirst();
        return method;
    }

    public Stream<MethodElement> getEnclosingMethods() {
        return this.typeElement == null ? Stream.empty() : IntrospectionUtils.getEnclosingMethodsStream((TypeElement)this.typeElement).map(executableElement -> new MethodElementAST((ExecutableElement)executableElement, this.processingEnvironment));
    }

    public Stream<Type> getImplementingInterfaces() {
        return this.typeElement == null ? Stream.empty() : this.typeElement.getInterfaces().stream().map(type -> new ASTType((TypeMirror)type, this.processingEnvironment));
    }

    public List<TypeGeneric> getGenerics() {
        return (List)this.typeGenerics.get();
    }

    public MetadataType asMetadataType() {
        return (MetadataType)this.typeLoader.load(this.typeMirror).orElseThrow(() -> new RuntimeException("Unable to obtain the MetadataType for the current type: " + this.typeMirror.toString()));
    }

    public boolean isAssignableTo(Class<?> clazz) {
        Types types = this.processingEnvironment.getTypeUtils();
        return types.isAssignable(types.erasure(this.typeMirror), types.erasure(this.getTypeMirrorFromClass(clazz)));
    }

    public boolean isAssignableTo(Type type) {
        if (type instanceof ASTType) {
            return this.processingEnvironment.getTypeUtils().isAssignable(this.processingEnvironment.getTypeUtils().erasure(this.typeMirror), this.processingEnvironment.getTypeUtils().erasure(((ASTType)type).typeMirror));
        }
        if (type.getDeclaringClass().isPresent()) {
            return this.processingEnvironment.getTypeUtils().isAssignable(this.processingEnvironment.getTypeUtils().erasure(this.typeMirror), this.getTypeMirrorFromClass((Class)type.getDeclaringClass().get()));
        }
        return false;
    }

    public boolean isSameType(Type type) {
        if (type instanceof ASTType) {
            TypeMirror givenType = this.processingEnvironment.getTypeUtils().erasure(((ASTType)type).typeMirror);
            TypeMirror actualType = this.processingEnvironment.getTypeUtils().erasure(this.typeMirror);
            return this.processingEnvironment.getTypeUtils().isSameType(actualType, givenType);
        }
        if (type.getDeclaringClass().isPresent()) {
            return this.isSameType((Class)type.getDeclaringClass().get());
        }
        return false;
    }

    public boolean isSameType(Class<?> clazz) {
        Types types = this.processingEnvironment.getTypeUtils();
        return types.isSameType(types.erasure(this.typeMirror), types.erasure(this.getTypeMirrorFromClass(clazz)));
    }

    public boolean isInstantiable() {
        return this.getClassInformation().isInstantiable();
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        TypeMirror typeMirror = this.getTypeMirrorFromClass(clazz);
        return this.processingEnvironment.getTypeUtils().isAssignable(typeMirror, this.processingEnvironment.getTypeUtils().erasure(this.typeMirror));
    }

    public boolean isAssignableFrom(Type type) {
        return type.isAssignableTo((Type)this);
    }

    private TypeMirror getTypeMirrorFromClass(Class<?> clazz) {
        return this.astUtils.getPrimitiveTypeMirror(clazz).orElseGet(() -> {
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                return this.processingEnvironment.getTypeUtils().getArrayType(this.getTypeMirrorFromClass(componentType));
            }
            return this.processingEnvironment.getElementUtils().getTypeElement(clazz.getName()).asType();
        });
    }

    public String getTypeName() {
        return this.typeElement == null ? this.typeMirror.toString() : this.typeElement.toString();
    }

    public Optional<Type> getSuperType() {
        TypeMirror superType = this.typeElement.getSuperclass();
        if (superType instanceof NoType) {
            return Optional.empty();
        }
        return Optional.of(new ASTType(superType, this.processingEnvironment));
    }

    public ClassInformationAnnotation getClassInformation() {
        return (ClassInformationAnnotation)this.classInformation.get();
    }

    public boolean isAnyType() {
        return this.typeMirror instanceof WildcardType && ((WildcardType)this.typeMirror).getSuperBound() == null && ((WildcardType)this.typeMirror).getExtendsBound() == null;
    }

    public List<OperationElement> getMethods() {
        return (List)this.methods.get();
    }

    private List<TypeGeneric> toTypeGenerics(TypeIntrospectionResult result, ProcessingEnvironment pe) {
        ArrayList<TypeGeneric> typeGenerics = new ArrayList<TypeGeneric>();
        for (TypeIntrospectionResult aResult : result.getGenerics()) {
            typeGenerics.add(new TypeGeneric((Type)new ASTType(aResult.getConcreteTypeMirror(), pe), aResult.getGenerics().isEmpty() ? Collections.emptyList() : this.toTypeGenerics(aResult, pe)));
        }
        return typeGenerics;
    }

    protected <R extends Annotation, S extends Annotation> List<Type> getClassArrayValue(Class<R> legacyAnnotationType, Class<S> sdkApiAnnotationType, Function<R, Class[]> legacyMapper, Function<S, Class[]> sdkApiMapper) {
        Optional<AnnotationValueFetcher<R>> legacyValueFetcher = this.getValueFromAnnotation(legacyAnnotationType);
        Optional<AnnotationValueFetcher<S>> sdkApiValueFetcher = this.getValueFromAnnotation(sdkApiAnnotationType);
        if (legacyValueFetcher.isPresent() && sdkApiValueFetcher.isPresent()) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' is annotated with both '%s' and '%s' at the same time", this.getTypeName(), this.getName(), legacyAnnotationType.getName(), sdkApiAnnotationType.getName()));
        }
        if (legacyValueFetcher.isPresent()) {
            return legacyValueFetcher.get().getClassArrayValue(legacyMapper);
        }
        if (sdkApiValueFetcher.isPresent()) {
            return sdkApiValueFetcher.get().getClassArrayValue(sdkApiMapper);
        }
        return Collections.emptyList();
    }

    public List<Type> getSuperTypeGenerics(Class superTypeClass) {
        return IntrospectionTypeUtils.getSuperTypeGenerics(this.typeMirror, superTypeClass, this.processingEnvironment).stream().map(typeMirror -> new ASTType((TypeMirror)typeMirror, this.processingEnvironment)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASTType type = (ASTType)o;
        return new EqualsBuilder().append((Object)this.typeMirror, (Object)type.typeMirror).append((Object)this.typeElement, (Object)type.typeElement).isEquals();
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.typeMirror).append((Object)this.typeElement).toHashCode();
    }

    public boolean isArray() {
        return this.typeMirror.getKind().equals((Object)TypeKind.ARRAY);
    }

    public Optional<Type> getArrayComponentType() {
        if (this.isArray()) {
            return Optional.of(new ASTType(((ArrayType)this.typeMirror).getComponentType(), this.processingEnvironment));
        }
        return Optional.empty();
    }
}

