/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.extension.internal.ASTType;
import org.mule.runtime.ast.extension.internal.IntrospectionTypeUtils;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.sdk.api.annotation.source.OnBackPressure;
import org.mule.sdk.api.runtime.source.Source;

public class SourceElementAST
extends ASTType
implements SourceElement {
    private LazyValue<List<Type>> sourceGenerics = new LazyValue(() -> IntrospectionTypeUtils.getSuperTypeGenerics(this.typeElement, this.isLegacySource(processingEnvironment, typeElement) ? org.mule.runtime.extension.api.runtime.source.Source.class : Source.class, processingEnvironment).stream().map(type -> new ASTType((TypeMirror)type, processingEnvironment)).collect(Collectors.toList()));

    public SourceElementAST(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        super(typeElement, processingEnvironment);
    }

    private boolean isLegacySource(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        return !IntrospectionTypeUtils.isSubType(typeElement, Source.class, processingEnvironment);
    }

    public List<Type> getSuperClassGenerics() {
        return (List)this.sourceGenerics.get();
    }

    public Optional<MethodElement> getOnResponseMethod() {
        return this.findMethodAnnotatedWith(OnSuccess.class, org.mule.sdk.api.annotation.execution.OnSuccess.class);
    }

    public Optional<MethodElement> getOnErrorMethod() {
        return this.findMethodAnnotatedWith(OnError.class, org.mule.sdk.api.annotation.execution.OnError.class);
    }

    public Optional<MethodElement> getOnTerminateMethod() {
        return this.findMethodAnnotatedWith(OnTerminate.class, org.mule.sdk.api.annotation.execution.OnTerminate.class);
    }

    public Optional<MethodElement> getOnBackPressureMethod() {
        return this.findMethodAnnotatedWith(org.mule.runtime.extension.api.annotation.source.OnBackPressure.class, OnBackPressure.class);
    }

    private Optional<MethodElement> findMethodAnnotatedWith(Class<? extends Annotation> ... annotationClasses) {
        return this.getMethods().stream().filter(op -> Arrays.stream(annotationClasses).filter(annotationClass -> op.isAnnotatedWith(annotationClass)).findFirst().isPresent()).map(elem -> elem).findFirst();
    }
}

