/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.runtime.ast.extension.internal.ExtensionTypeUtils;

public class ExtensionTypeHandler
implements TypeHandler {
    private ProcessingEnvironment processingEnvironment;

    public ExtensionTypeHandler(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public boolean handles(TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && this.isHandled(typeMirror);
    }

    private boolean isHandled(TypeMirror typeMirror) {
        return ExtensionTypeUtils.isParameterResolverType(typeMirror, this.processingEnvironment) || ExtensionTypeUtils.isLiteralType(typeMirror, this.processingEnvironment) || ExtensionTypeUtils.isTypedValueType(typeMirror, this.processingEnvironment);
    }

    public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor, IntrospectionContext context) {
        if (typeMirror instanceof DeclaredType && this.isHandled(typeMirror)) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            if (typeArguments.isEmpty()) {
                throw new IllegalArgumentException("The given TypeMirror " + String.valueOf(typeMirror) + " doesn't provide generics");
            }
            return typeArguments.get(0).accept(typeVisitor, context);
        }
        throw new IllegalArgumentException("The given TypeMirror " + String.valueOf(typeMirror) + " it's not supported by this Handler");
    }
}

